/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.body;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.net.url.UrlQuery;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.http.client.body.FormBody;
import org.dromara.hutool.http.meta.ContentType;

public class UrlEncodedFormBody
extends FormBody<UrlEncodedFormBody> {
    public static UrlEncodedFormBody of(Map<String, Object> form, Charset charset) {
        return new UrlEncodedFormBody(form, charset);
    }

    public UrlEncodedFormBody(Map<String, Object> form, Charset charset) {
        super(form, charset);
    }

    @Override
    public void write(OutputStream out) {
        byte[] bytes = ByteUtil.toBytes(UrlQuery.of(this.form, true).build(this.charset), this.charset);
        IoUtil.write(out, false, bytes);
    }

    @Override
    public String getContentType() {
        return ContentType.FORM_URLENCODED.toString(this.charset);
    }
}

