/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.dromara.hutool.core.annotation.AnnotationMappingProxy;
import org.dromara.hutool.core.annotation.AnnotationProxy;
import org.dromara.hutool.core.annotation.elements.CombinationAnnotatedElement;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.func.LambdaInfo;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.map.WeakConcurrentMap;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.CharSequenceUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class AnnotationUtil {
    private static final String JDK_MEMBER_ATTRIBUTE = "memberValues";
    private static final String SPRING_MEMBER_ATTRIBUTE = "valueCache";
    private static final String HUTOOL_MEMBER_ATTRIBUTE = "valueCache";
    private static final String SPRING_INVOCATION_HANDLER = "SynthesizedMergedAnnotationInvocationHandler";
    private static final Map<AnnotatedElement, Annotation[]> DECLARED_ANNOTATIONS_CACHE = new WeakConcurrentMap<AnnotatedElement, Annotation[]>();

    public static Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        return DECLARED_ANNOTATIONS_CACHE.computeIfAbsent(element, AnnotatedElement::getDeclaredAnnotations);
    }

    public static CombinationAnnotatedElement toCombination(AnnotatedElement annotationEle) {
        if (annotationEle instanceof CombinationAnnotatedElement) {
            return (CombinationAnnotatedElement)annotationEle;
        }
        return new CombinationAnnotatedElement(annotationEle);
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination) {
        return AnnotationUtil.getAnnotations(annotationEle, isToCombination, (Predicate<Annotation>)null);
    }

    public static <T> T[] getCombinationAnnotations(AnnotatedElement annotationEle, Class<T> annotationType) {
        return AnnotationUtil.getAnnotations(annotationEle, true, annotationType);
    }

    public static <T> T[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Class<T> annotationType) {
        Annotation[] annotations = AnnotationUtil.getAnnotations(annotationEle, isToCombination, (Annotation annotation) -> null == annotationType || annotationType.isAssignableFrom(annotation.getClass()));
        T[] result = ArrayUtil.newArray(annotationType, annotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = annotations[i];
        }
        return result;
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Predicate<Annotation> predicate) {
        if (null == annotationEle) {
            return null;
        }
        if (isToCombination) {
            if (null == predicate) {
                return AnnotationUtil.toCombination(annotationEle).getAnnotations();
            }
            return CombinationAnnotatedElement.of(annotationEle, predicate).getAnnotations();
        }
        Annotation[] result = annotationEle.getAnnotations();
        if (null == predicate) {
            return result;
        }
        return ArrayUtil.filter(result, predicate);
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotationEle, Class<A> annotationType) {
        return null == annotationEle ? null : (A)AnnotationUtil.toCombination(annotationEle).getAnnotation(annotationType);
    }

    public static boolean hasAnnotation(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        return null != AnnotationUtil.getAnnotation(annotationEle, annotationType);
    }

    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) throws HutoolException {
        return AnnotationUtil.getAnnotationValue(annotationEle, annotationType, "value");
    }

    public static <A extends Annotation, R> R getAnnotationValue(AnnotatedElement annotationEle, SerFunction<A, R> propertyName) {
        if (propertyName == null) {
            return null;
        }
        LambdaInfo lambda = LambdaUtil.resolve(propertyName);
        String instantiatedMethodType = lambda.getLambda().getInstantiatedMethodType();
        Class annotationClass = ClassLoaderUtil.loadClass(StrUtil.sub(instantiatedMethodType, 2, StrUtil.indexOf(instantiatedMethodType, ';')));
        return (R)AnnotationUtil.getAnnotationValue(annotationEle, annotationClass, lambda.getLambda().getImplMethodName());
    }

    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType, String propertyName) throws HutoolException {
        Annotation annotation = AnnotationUtil.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        Method method = MethodUtil.getMethodOfObj(annotation, propertyName, new Object[0]);
        if (null == method) {
            return null;
        }
        return MethodUtil.invoke((Object)annotation, method, new Object[0]);
    }

    public static Map<String, Object> getAnnotationValueMap(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) throws HutoolException {
        Annotation annotation = AnnotationUtil.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        Method[] methods = MethodUtil.getMethods(annotationType, t -> {
            if (ArrayUtil.isEmpty(t.getParameterTypes())) {
                String name = t.getName();
                return !"hashCode".equals(name) && !"toString".equals(name) && !"annotationType".equals(name);
            }
            return false;
        });
        HashMap<String, Object> result = new HashMap<String, Object>(methods.length, 1.0f);
        for (Method method : methods) {
            result.put(method.getName(), MethodUtil.invoke((Object)annotation, method, new Object[0]));
        }
        return result;
    }

    public static RetentionPolicy getRetentionPolicy(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        if (null == retention) {
            return RetentionPolicy.CLASS;
        }
        return retention.value();
    }

    public static ElementType[] getTargetType(Class<? extends Annotation> annotationType) {
        Target target = annotationType.getAnnotation(Target.class);
        if (null == target) {
            return ElementType.values();
        }
        return target.value();
    }

    public static boolean isDocumented(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Documented.class);
    }

    public static boolean isInherited(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Inherited.class);
    }

    public static void setValue(Annotation annotation, String annotationField, Object value) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        String memberAttributeName = JDK_MEMBER_ATTRIBUTE;
        if (CharSequenceUtil.contains((CharSequence)invocationHandler.getClass().getName(), SPRING_INVOCATION_HANDLER)) {
            memberAttributeName = "valueCache";
        } else if (invocationHandler instanceof AnnotationMappingProxy) {
            memberAttributeName = "valueCache";
        }
        Map memberValues = (Map)FieldUtil.getFieldValue((Object)invocationHandler, memberAttributeName);
        memberValues.put(annotationField, value);
    }

    public static <T extends Annotation> T getAnnotationAlias(AnnotatedElement annotationEle, Class<T> annotationType) {
        T annotation = AnnotationUtil.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new AnnotationProxy<T>(annotation)));
    }

    public static Method[] getAnnotationAttributes(Class<? extends Annotation> annotationType) {
        return (Method[])Stream.of(MethodUtil.getDeclaredMethods(annotationType)).filter(AnnotationUtil::isAnnotationAttribute).toArray(Method[]::new);
    }

    public static boolean isAnnotationAttribute(Method attribute) {
        return !MethodUtil.isEqualsMethod(attribute) && !MethodUtil.isHashCodeMethod(attribute) && !MethodUtil.isToStringMethod(attribute) && ArrayUtil.isEmpty(attribute.getParameterTypes()) && ObjUtil.notEquals(attribute.getReturnType(), Void.class) && !Modifier.isStatic(attribute.getModifiers()) && Modifier.isPublic(attribute.getModifiers()) && !attribute.isBridge() && !attribute.isSynthetic();
    }

    public static void clearCaches() {
        DECLARED_ANNOTATIONS_CACHE.clear();
    }
}

