/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.convert.BasicType;
import org.dromara.hutool.core.convert.CompositeConverter;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.impl.CollectionConverter;
import org.dromara.hutool.core.convert.impl.EnumConverter;
import org.dromara.hutool.core.convert.impl.MapConverter;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.math.ChineseNumberFormatter;
import org.dromara.hutool.core.math.ChineseNumberParser;
import org.dromara.hutool.core.math.EnglishNumberFormatter;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.UnicodeUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class Convert {
    public static String toStr(Object value, String defaultValue) {
        return Convert.convertQuietly(String.class, value, defaultValue);
    }

    public static String toStr(Object value) {
        return Convert.toStr(value, null);
    }

    public static String[] toStrArray(Object value) {
        return Convert.convert(String[].class, value);
    }

    public static Character toChar(Object value, Character defaultValue) {
        return Convert.convertQuietly(Character.class, value, defaultValue);
    }

    public static Character toChar(Object value) {
        return Convert.toChar(value, null);
    }

    public static Character[] toCharArray(Object value) {
        return Convert.convert(Character[].class, value);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        return Convert.convertQuietly(Byte.class, value, defaultValue);
    }

    public static Byte toByte(Object value) {
        return Convert.toByte(value, null);
    }

    public static Byte[] toByteArray(Object value) {
        return Convert.convert(Byte[].class, value);
    }

    public static byte[] toPrimitiveByteArray(Object value) {
        return Convert.convert(byte[].class, value);
    }

    public static Short toShort(Object value, Short defaultValue) {
        return Convert.convertQuietly(Short.class, value, defaultValue);
    }

    public static Short toShort(Object value) {
        return Convert.toShort(value, null);
    }

    public static Short[] toShortArray(Object value) {
        return Convert.convert(Short[].class, value);
    }

    public static Number toNumber(Object value, Number defaultValue) {
        return Convert.convertQuietly(Number.class, value, defaultValue);
    }

    public static Number toNumber(Object value) {
        return Convert.toNumber(value, null);
    }

    public static Number[] toNumberArray(Object value) {
        return Convert.convert(Number[].class, value);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        return Convert.convertQuietly(Integer.class, value, defaultValue);
    }

    public static Integer toInt(Object value) {
        return Convert.toInt(value, null);
    }

    public static Integer[] toIntArray(Object value) {
        return Convert.convert(Integer[].class, value);
    }

    public static Long toLong(Object value, Long defaultValue) {
        return Convert.convertQuietly(Long.class, value, defaultValue);
    }

    public static Long toLong(Object value) {
        return Convert.toLong(value, null);
    }

    public static Long[] toLongArray(Object value) {
        return Convert.convert(Long[].class, value);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        return Convert.convertQuietly(Double.class, value, defaultValue);
    }

    public static Double toDouble(Object value) {
        return Convert.toDouble(value, null);
    }

    public static Double[] toDoubleArray(Object value) {
        return Convert.convert(Double[].class, value);
    }

    public static Float toFloat(Object value, Float defaultValue) {
        return Convert.convertQuietly(Float.class, value, defaultValue);
    }

    public static Float toFloat(Object value) {
        return Convert.toFloat(value, null);
    }

    public static Float[] toFloatArray(Object value) {
        return Convert.convert(Float[].class, value);
    }

    public static Boolean toBoolean(Object value, Boolean defaultValue) {
        return Convert.convertQuietly(Boolean.class, value, defaultValue);
    }

    public static Boolean toBoolean(Object value) {
        return Convert.toBoolean(value, null);
    }

    public static Boolean[] toBooleanArray(Object value) {
        return Convert.convert(Boolean[].class, value);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        return Convert.convertQuietly(BigInteger.class, value, defaultValue);
    }

    public static BigInteger toBigInteger(Object value) {
        return Convert.toBigInteger(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        return Convert.convertQuietly(BigDecimal.class, value, defaultValue);
    }

    public static BigDecimal toBigDecimal(Object value) {
        return Convert.toBigDecimal(value, null);
    }

    public static Date toDate(Object value, Date defaultValue) {
        return Convert.convertQuietly(Date.class, value, defaultValue);
    }

    public static LocalDateTime toLocalDateTime(Object value, LocalDateTime defaultValue) {
        return Convert.convertQuietly(LocalDateTime.class, value, defaultValue);
    }

    public static LocalDateTime toLocalDateTime(Object value) {
        return Convert.toLocalDateTime(value, null);
    }

    public static Date toInstant(Object value, Date defaultValue) {
        return Convert.convertQuietly(Instant.class, value, defaultValue);
    }

    public static Date toDate(Object value) {
        return Convert.toDate(value, null);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value, E defaultValue) {
        try {
            return (E)((Enum)EnumConverter.INSTANCE.convert(clazz, value));
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value) {
        return Convert.toEnum(clazz, value, null);
    }

    public static Collection<?> toCollection(Class<?> collectionType, Class<?> elementType, Object value) {
        return new CollectionConverter().convert(collectionType, elementType, value);
    }

    public static List<?> toList(Object value) {
        return Convert.convert(List.class, value);
    }

    public static <T> List<T> toList(Class<T> elementType, Object value) {
        return (List)Convert.toCollection(ArrayList.class, elementType, value);
    }

    public static <T> Set<T> toSet(Class<T> elementType, Object value) {
        return (Set)Convert.toCollection(HashSet.class, elementType, value);
    }

    public static <K, V> Map<K, V> toMap(Class<K> keyType, Class<V> valueType, Object value) {
        if (value instanceof Map) {
            return Convert.toMap(value.getClass(), keyType, valueType, value);
        }
        return Convert.toMap(HashMap.class, keyType, valueType, value);
    }

    public static <K, V> Map<K, V> toMap(Class<?> mapType, Class<K> keyType, Class<V> valueType, Object value) {
        return MapConverter.INSTANCE.convert(mapType, keyType, valueType, value);
    }

    public static <T> T convertByClassName(String className, Object value) throws ConvertException {
        return Convert.convert(ClassLoaderUtil.loadClass(className), value);
    }

    public static <T> T convert(Class<T> type, Object value) throws ConvertException {
        return Convert.convert(type, value);
    }

    public static <T> T convert(TypeReference<T> reference, Object value) throws ConvertException {
        return Convert.convert(reference.getType(), value, null);
    }

    public static <T> T convert(Type type, Object value) throws ConvertException {
        return Convert.convert(type, value, null);
    }

    public static <T> T convert(Class<T> type, Object value, T defaultValue) throws ConvertException {
        return Convert.convert(type, value, defaultValue);
    }

    public static <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return Convert.convertWithCheck(type, value, defaultValue, false);
    }

    public static <T> T convertQuietly(Type type, Object value) {
        return Convert.convertQuietly(type, value, null);
    }

    public static <T> T convertQuietly(Type type, Object value, T defaultValue) {
        return Convert.convertWithCheck(type, value, defaultValue, true);
    }

    public static <T> T convertWithCheck(Type type, Object value, T defaultValue, boolean quietly) {
        CompositeConverter compositeConverter = CompositeConverter.getInstance();
        try {
            return compositeConverter.convert(type, value, defaultValue);
        }
        catch (Exception e) {
            if (quietly) {
                return defaultValue;
            }
            throw e;
        }
    }

    public static String toSBC(String input) {
        return Convert.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        if (StrUtil.isEmpty(input)) {
            return input;
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        return Convert.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        if (StrUtil.isBlank(text)) {
            return text;
        }
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000' || c[i] == '\u00a0' || c[i] == '\u2007' || c[i] == '\u202f') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String toHex(String str, Charset charset) {
        return HexUtil.encodeStr(str, charset);
    }

    public static String toHex(byte[] bytes) {
        return HexUtil.encodeStr(bytes);
    }

    public static byte[] hexToBytes(String src) {
        return HexUtil.decode(src.toCharArray());
    }

    public static String hexToStr(String hexStr, Charset charset) {
        return HexUtil.decodeStr(hexStr, charset);
    }

    public static String strToUnicode(String strText) {
        return UnicodeUtil.toUnicode(strText);
    }

    public static String unicodeToStr(String unicode) {
        return UnicodeUtil.toString(unicode);
    }

    public static String convertCharset(String str, String sourceCharset, String destCharset) {
        if (ArrayUtil.hasBlank(str, sourceCharset, destCharset)) {
            return str;
        }
        return CharsetUtil.convert(str, sourceCharset, destCharset);
    }

    public static long convertTime(long sourceDuration, TimeUnit sourceUnit, TimeUnit destUnit) {
        Assert.notNull(sourceUnit, "sourceUnit is null !", new Object[0]);
        Assert.notNull(destUnit, "destUnit is null !", new Object[0]);
        return destUnit.convert(sourceDuration, sourceUnit);
    }

    public static Class<?> wrap(Class<?> clazz) {
        return BasicType.wrap(clazz);
    }

    public static Class<?> unWrap(Class<?> clazz) {
        return BasicType.unWrap(clazz);
    }

    public static String numberToWord(Number number) {
        return EnglishNumberFormatter.format(number);
    }

    public static String numberToSimple(Number number) {
        return EnglishNumberFormatter.formatSimple(number.longValue());
    }

    public static String numberToChinese(double number, boolean isUseTraditional) {
        return ChineseNumberFormatter.of().setUseTraditional(isUseTraditional).format(number);
    }

    public static BigDecimal chineseToNumber(String number) {
        return ChineseNumberParser.parseFromChineseNumber(number);
    }

    public static String digitToChinese(Number n) {
        if (null == n) {
            return "\u96f6";
        }
        return ChineseNumberFormatter.of().setUseTraditional(true).setMoneyMode(true).format(n.doubleValue());
    }

    public static BigDecimal chineseMoneyToNumber(String chineseMoneyAmount) {
        return ChineseNumberParser.parseFromChineseMoney(chineseMoneyAmount);
    }

    public static byte intToByte(int intValue) {
        return (byte)intValue;
    }

    public static int byteToUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static short bytesToShort(byte[] bytes) {
        return ByteUtil.toShort(bytes);
    }

    public static byte[] shortToBytes(short shortValue) {
        return ByteUtil.toBytes(shortValue);
    }

    public static int bytesToInt(byte[] bytes) {
        return ByteUtil.toInt(bytes);
    }

    public static byte[] intToBytes(int intValue) {
        return ByteUtil.toBytes(intValue);
    }

    public static byte[] longToBytes(long longValue) {
        return ByteUtil.toBytes(longValue);
    }

    public static long bytesToLong(byte[] bytes) {
        return ByteUtil.toLong(bytes);
    }
}

