/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.math;

public class RomanNumberFormatter {
    public static String intToRoman(int num) {
        if (num > 3999 || num < 1) {
            return "";
        }
        String[] thousands = new String[]{"", "M", "MM", "MMM"};
        String[] hundreds = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
        String[] tens = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
        String[] ones = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        return thousands[num / 1000] + hundreds[num % 1000 / 100] + tens[num % 100 / 10] + ones[num % 10];
    }

    public static int romanToInt(String roman) {
        int result = 0;
        int prevValue = 0;
        for (int i = roman.length() - 1; i >= 0; --i) {
            int currValue;
            char c = roman.charAt(i);
            switch (c) {
                case 'I': {
                    currValue = 1;
                    break;
                }
                case 'V': {
                    currValue = 5;
                    break;
                }
                case 'X': {
                    currValue = 10;
                    break;
                }
                case 'L': {
                    currValue = 50;
                    break;
                }
                case 'C': {
                    currValue = 100;
                    break;
                }
                case 'D': {
                    currValue = 500;
                    break;
                }
                case 'M': {
                    currValue = 1000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Roman character: " + c);
                }
            }
            result = currValue < prevValue ? (result -= currValue) : (result += currValue);
            prevValue = currValue;
        }
        return result;
    }
}

