/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.NullWrapperBean;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.collection.set.UniqueKeySet;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.map.reference.WeakConcurrentMap;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.method.MethodHandleUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.BooleanUtil;

public class MethodUtil {
    private static final WeakConcurrentMap<Class<?>, Method[]> METHODS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Method[]> DECLARED_METHODS_CACHE = new WeakConcurrentMap();

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        HashSet<String> methodSet = new HashSet<String>();
        Method[] methodArray = MethodUtil.getPublicMethods(clazz);
        if (ArrayUtil.isNotEmpty(methodArray)) {
            for (Method method : methodArray) {
                methodSet.add(method.getName());
            }
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static Method[] getPublicMethods(Class<?> clazz, Predicate<Method> predicate) {
        if (null == clazz) {
            return null;
        }
        Method[] methods = MethodUtil.getPublicMethods(clazz);
        if (null == predicate) {
            return methods;
        }
        return ArrayUtil.filter(methods, predicate);
    }

    public static Method[] getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        HashSet<Method> excludeMethodSet = SetUtil.of(excludeMethods);
        return MethodUtil.getPublicMethods(clazz, (Method method) -> !excludeMethodSet.contains(method));
    }

    public static Method[] getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        HashSet<String> excludeMethodNameSet = SetUtil.of(excludeMethodNames);
        return MethodUtil.getPublicMethods(clazz, (Method method) -> !excludeMethodNameSet.contains(method.getName()));
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || StrUtil.isBlank(methodName)) {
            return null;
        }
        return MethodUtil.getMethod(obj.getClass(), methodName, ClassUtil.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return MethodUtil.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return MethodUtil.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        Method[] methods = MethodUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || !ClassUtil.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return MethodUtil.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        return MethodUtil.getMethodByName(clazz, true, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        Method[] methods = MethodUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = MethodUtil.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Predicate<Method> predicate) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return ArrayUtil.filter(MethodUtil.getMethods(clazz), predicate);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return METHODS_CACHE.computeIfAbsent(beanClass, key -> MethodUtil.getMethodsDirectly(beanClass, true, true));
    }

    public static Method[] getDeclaredMethods(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return DECLARED_METHODS_CACHE.computeIfAbsent(beanClass, key -> MethodUtil.getMethodsDirectly(beanClass, false, Objects.equals(Object.class, beanClass)));
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        Assert.notNull(beanClass);
        if (beanClass.isInterface()) {
            return withSupers ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        }
        UniqueKeySet<String, Method> result = new UniqueKeySet<String, Method>(true, MethodUtil::getUniqueKey);
        Class<?> searchType = beanClass;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            result.addAllIfAbsent(Arrays.asList(searchType.getDeclaredMethods()));
            result.addAllIfAbsent(MethodUtil.getDefaultMethodsFromInterface(searchType));
            searchType = withSupers && !searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return result.toArray(new Method[0]);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || 1 != method.getParameterCount() || !"equals".equals(method.getName())) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && "hashCode".equals(method.getName()) && MethodUtil.isEmptyParam(method);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && "toString".equals(method.getName()) && MethodUtil.isEmptyParam(method);
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterCount() == 0;
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return MethodUtil.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        int parameterCount = method.getParameterCount();
        switch (parameterCount) {
            case 0: {
                return MethodUtil.isGetter(method, ignoreCase);
            }
            case 1: {
                return MethodUtil.isSetter(method, ignoreCase);
            }
        }
        return false;
    }

    public static boolean isSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (1 != parameterCount) {
            return false;
        }
        String name = method.getName();
        if ("set".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        return name.startsWith("set");
    }

    public static boolean isGetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (0 != parameterCount) {
            return false;
        }
        String name = method.getName();
        if ("getClass".equals(name) || "get".equals(name) || "is".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        if (name.startsWith("is")) {
            return BooleanUtil.isBoolean(method.getReturnType());
        }
        return name.startsWith("get");
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws HutoolException {
        return MethodUtil.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) throws HutoolException {
        Class<?>[] types = method.getParameterTypes();
        if (null != args) {
            Assert.isTrue(args.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, types.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = types[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassUtil.getDefaultValue(type);
            }
        }
        return MethodUtil.invoke(obj, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws HutoolException {
        try {
            return MethodHandleUtil.invoke(obj, method, args);
        }
        catch (Exception e) {
            try {
                return (T)method.invoke(ModifierUtil.isStatic(method) ? null : obj, MethodUtil.actualArgs(method, args));
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new HutoolException(ex);
            }
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws HutoolException {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = MethodUtil.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new HutoolException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        return MethodUtil.invoke(obj, method, args);
    }

    public static <T> T invoke(String classNameWithMethodName, Object[] args) {
        return MethodUtil.invoke(classNameWithMethodName, false, args);
    }

    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object ... args) {
        if (StrUtil.isBlank(classNameWithMethodName)) {
            throw new HutoolException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new HutoolException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        return MethodUtil.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object[] args) {
        return MethodUtil.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object ... args) {
        Class clazz = ClassLoaderUtil.loadClass(className);
        try {
            Method method = MethodUtil.getMethod(clazz, methodName, ClassUtil.getClasses(args));
            if (null == method) {
                throw new NoSuchMethodException(StrUtil.format("No such method: [{}]", methodName));
            }
            if (ModifierUtil.isStatic(method)) {
                return MethodUtil.invoke(null, method, args);
            }
            return MethodUtil.invoke(isSingleton ? Singleton.get(clazz, new Object[0]) : ConstructorUtil.newInstance(clazz, new Object[0]), method, args);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrapRuntime(e);
        }
    }

    public static Object[] actualArgs(Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (1 == parameterTypes.length && parameterTypes[0].isArray()) {
            return args;
        }
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = ClassUtil.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (args[i] instanceof NullWrapperBean) {
                    actualArgs[i] = null;
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = Convert.convert(parameterTypes[i], args[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        return actualArgs;
    }

    private static String getUniqueKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append('#');
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method m : ifc.getMethods()) {
                if (ModifierUtil.isAbstract(m)) continue;
                result.add(m);
            }
        }
        return result;
    }
}

