/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.path.node;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.path.node.Node;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;

public class ListNode
implements Node {
    final List<String> names;

    public ListNode(String expression) {
        this.names = SplitUtil.splitTrim(expression, ",");
    }

    @Override
    public Object getValue(Object bean) {
        List<String> names = this.names;
        if (bean instanceof Collection) {
            return CollUtil.getAny((Collection)bean, Convert.convert(int[].class, names));
        }
        if (ArrayUtil.isArray(bean)) {
            return ArrayUtil.getAny(bean, Convert.convert(int[].class, names));
        }
        String[] unWrappedNames = this.getUnWrappedNames(names);
        if (bean instanceof Map) {
            return MapUtil.getAny((Map)bean, unWrappedNames);
        }
        Map<String, Object> map = BeanUtil.beanToMap(bean, new String[0]);
        return MapUtil.getAny(map, unWrappedNames);
    }

    @Override
    public Object setValue(Object bean, Object value) {
        throw new UnsupportedOperationException("Can not set value to multi names.");
    }

    public String toString() {
        return this.names.toString();
    }

    private String[] getUnWrappedNames(List<String> names) {
        String[] unWrappedNames = new String[names.size()];
        for (int i = 0; i < unWrappedNames.length; ++i) {
            unWrappedNames[i] = StrUtil.unWrap(names.get(i), '\'');
        }
        return unWrappedNames;
    }
}

