/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.cache.impl;

import java.util.Iterator;
import java.util.concurrent.locks.StampedLock;
import org.dromara.hutool.core.cache.impl.AbstractCache;
import org.dromara.hutool.core.cache.impl.CacheObj;
import org.dromara.hutool.core.cache.impl.CacheObjIterator;
import org.dromara.hutool.core.collection.iter.CopiedIter;

public abstract class StampedCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;
    protected final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        long stamp = this.lock.writeLock();
        try {
            this.putWithoutLock(key, object, timeout);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public boolean containsKey(K key) {
        return null != this.get(key, false, false);
    }

    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        return this.get(key, isUpdateLastAccess, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CacheObj<K, V>> cacheObjIterator() {
        CopiedIter copiedIterator;
        long stamp = this.lock.readLock();
        try {
            copiedIterator = CopiedIter.copyOf(this.cacheObjIter());
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        return new CacheObjIterator(copiedIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        long stamp = this.lock.writeLock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        CacheObj co;
        long stamp = this.lock.writeLock();
        try {
            co = this.removeWithoutLock(key);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }

    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V get(K key, boolean isUpdateLastAccess, boolean isUpdateCount) {
        long stamp = this.lock.tryOptimisticRead();
        CacheObj co = this.getWithoutLock(key);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                co = this.getWithoutLock(key);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        if (null == co) {
            if (isUpdateCount) {
                this.missCount.increment();
            }
            return null;
        }
        if (!co.isExpired()) {
            if (isUpdateCount) {
                this.hitCount.increment();
            }
            return co.get(isUpdateLastAccess);
        }
        return this.getOrRemoveExpired(key, isUpdateCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getOrRemoveExpired(K key, boolean isUpdateCount) {
        CacheObj co;
        long stamp = this.lock.writeLock();
        try {
            co = this.getWithoutLock(key);
            if (null == co) {
                V v = null;
                return v;
            }
            if (!co.isExpired()) {
                if (isUpdateCount) {
                    this.hitCount.increment();
                }
                Object v = co.getValue();
                return v;
            }
            co = this.removeWithoutLock(key);
            if (isUpdateCount) {
                this.missCount.increment();
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
        return null;
    }
}

