/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date;

import java.time.DayOfWeek;
import org.dromara.hutool.core.lang.Assert;

public enum Week {
    SUNDAY(1),
    MONDAY(2),
    TUESDAY(3),
    WEDNESDAY(4),
    THURSDAY(5),
    FRIDAY(6),
    SATURDAY(7);

    private static final Week[] ENUMS;
    private final int value;

    private Week(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public int getIso8601Value() {
        int iso8601IntValue = this.getValue() - 1;
        if (0 == iso8601IntValue) {
            iso8601IntValue = 7;
        }
        return iso8601IntValue;
    }

    public String toChinese() {
        return this.toChinese("\u661f\u671f");
    }

    public String toChinese(String weekNamePre) {
        switch (this) {
            case SUNDAY: {
                return weekNamePre + "\u65e5";
            }
            case MONDAY: {
                return weekNamePre + "\u4e00";
            }
            case TUESDAY: {
                return weekNamePre + "\u4e8c";
            }
            case WEDNESDAY: {
                return weekNamePre + "\u4e09";
            }
            case THURSDAY: {
                return weekNamePre + "\u56db";
            }
            case FRIDAY: {
                return weekNamePre + "\u4e94";
            }
            case SATURDAY: {
                return weekNamePre + "\u516d";
            }
        }
        return null;
    }

    public DayOfWeek toJdkDayOfWeek() {
        return DayOfWeek.of(this.getIso8601Value());
    }

    public static Week of(int calendarWeekIntValue) {
        if (calendarWeekIntValue > ENUMS.length || calendarWeekIntValue < 1) {
            return null;
        }
        return ENUMS[calendarWeekIntValue - 1];
    }

    public static Week of(String name) throws IllegalArgumentException {
        if (null != name && name.length() > 1) {
            switch (Character.toLowerCase(name.charAt(0))) {
                case 'm': {
                    return MONDAY;
                }
                case 'w': {
                    return WEDNESDAY;
                }
                case 'f': {
                    return FRIDAY;
                }
                case 't': {
                    switch (Character.toLowerCase(name.charAt(1))) {
                        case 'u': {
                            return TUESDAY;
                        }
                        case 'h': {
                            return THURSDAY;
                        }
                    }
                    break;
                }
                case 's': {
                    switch (Character.toLowerCase(name.charAt(1))) {
                        case 'a': {
                            return SATURDAY;
                        }
                        case 'u': {
                            return SUNDAY;
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("Invalid Week name: " + name);
    }

    public static Week of(DayOfWeek dayOfWeek) {
        Assert.notNull(dayOfWeek);
        int week = dayOfWeek.getValue() + 1;
        if (8 == week) {
            week = 1;
        }
        return Week.of(week);
    }

    static {
        ENUMS = Week.values();
    }
}

