/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date.format.parser;

import org.dromara.hutool.core.date.DateException;
import org.dromara.hutool.core.date.DatePattern;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.format.DefaultDateBasic;
import org.dromara.hutool.core.date.format.parser.PredicateDateParser;
import org.dromara.hutool.core.math.NumberUtil;

public class PureDateParser
extends DefaultDateBasic
implements PredicateDateParser {
    private static final long serialVersionUID = 1L;
    public static PureDateParser INSTANCE = new PureDateParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return NumberUtil.isNumber(dateStr);
    }

    @Override
    public DateTime parse(String source) throws DateException {
        int length = source.length();
        if (length == "yyyyMMddHHmmss".length()) {
            return new DateTime((CharSequence)source, DatePattern.PURE_DATETIME_FORMAT);
        }
        if (length == "yyyyMMddHHmmssSSS".length()) {
            return new DateTime((CharSequence)source, DatePattern.PURE_DATETIME_MS_FORMAT);
        }
        if (length == "yyyyMMdd".length()) {
            return new DateTime((CharSequence)source, DatePattern.PURE_DATE_FORMAT);
        }
        if (length == "HHmmss".length()) {
            return new DateTime((CharSequence)source, DatePattern.PURE_TIME_FORMAT);
        }
        if (length >= 11 && length <= 13) {
            return new DateTime(NumberUtil.parseLong(source));
        }
        throw new DateException("No pure format fit for date String [{}] !", source);
    }
}

