/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.dromara.hutool.core.annotation.AnnotatedElementUtil;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.func.PredicateUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.text.CharSequenceUtil;
import org.jetbrains.annotations.NotNull;

public class MethodMatcherUtil {
    @SafeVarargs
    public static Predicate<Method> noneMatch(Predicate<Method> ... matchers) {
        return PredicateUtil.none(matchers);
    }

    @SafeVarargs
    public static Predicate<Method> anyMatch(Predicate<Method> ... matchers) {
        return PredicateUtil.or(matchers);
    }

    @SafeVarargs
    public static Predicate<Method> allMatch(Predicate<Method> ... matchers) {
        return PredicateUtil.and(matchers);
    }

    public static Predicate<Method> isPublic() {
        return MethodMatcherUtil.forModifiers(1);
    }

    public static Predicate<Method> isStatic() {
        return MethodMatcherUtil.forModifiers(8);
    }

    public static Predicate<Method> isPublicStatic() {
        return MethodMatcherUtil.forModifiers(1, 8);
    }

    public static Predicate<Method> forModifiers(int ... modifiers) {
        return method -> ModifierUtil.hasAllModifier(method.getModifiers(), modifiers);
    }

    public static Predicate<Method> hasDeclaredAnnotation(Class<? extends Annotation> annotationType) {
        return method -> method.isAnnotationPresent(annotationType);
    }

    public static Predicate<Method> hasAnnotation(Class<? extends Annotation> annotationType) {
        return method -> AnnotatedElementUtil.isAnnotationPresent(method, annotationType);
    }

    public static Predicate<Method> hasAnnotationOnDeclaringClass(Class<? extends Annotation> annotationType) {
        return method -> AnnotatedElementUtil.isAnnotationPresent(method.getDeclaringClass(), annotationType);
    }

    public static Predicate<Method> hasAnnotationOnMethodOrDeclaringClass(Class<? extends Annotation> annotationType) {
        return method -> AnnotatedElementUtil.isAnnotationPresent(method, annotationType) || AnnotatedElementUtil.isAnnotationPresent(method.getDeclaringClass(), annotationType);
    }

    public static Predicate<Method> forGetterMethod(String fieldName, Class<?> fieldType) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(fieldType);
        Predicate<Method> nameMatcher = MethodMatcherUtil.forName(CharSequenceUtil.upperFirstAndAddPre(fieldName, "get"));
        nameMatcher = nameMatcher.or(MethodMatcherUtil.forName(fieldName));
        if (Objects.equals(Boolean.TYPE, fieldType) || Objects.equals(Boolean.class, fieldType)) {
            nameMatcher = nameMatcher.or(MethodMatcherUtil.forName(CharSequenceUtil.upperFirstAndAddPre(fieldName, "is")));
        }
        return MethodMatcherUtil.allMatch(nameMatcher, MethodMatcherUtil.forReturnType(fieldType), MethodMatcherUtil.forNoneParameter());
    }

    public static Predicate<Method> forGetterMethod(Field field) {
        Objects.requireNonNull(field);
        return MethodMatcherUtil.forGetterMethod(field.getName(), field.getType());
    }

    public static Predicate<Method> forSetterMethod(String fieldName, Class<?> fieldType) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(fieldType);
        Predicate<Method> nameMatcher = MethodMatcherUtil.forName(CharSequenceUtil.upperFirstAndAddPre(fieldName, "set")).or(MethodMatcherUtil.forName(fieldName));
        return MethodMatcherUtil.allMatch(nameMatcher, MethodMatcherUtil.forParameterTypes(fieldType));
    }

    public static Predicate<Method> forSetterMethod(Field field) {
        Objects.requireNonNull(field);
        return MethodMatcherUtil.forSetterMethod(field.getName(), field.getType());
    }

    public static Predicate<Method> forNameAndParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forName(methodName), MethodMatcherUtil.forParameterTypes(parameterTypes));
    }

    public static Predicate<Method> forNameAndStrictParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forName(methodName), MethodMatcherUtil.forStrictParameterTypes(parameterTypes));
    }

    public static Predicate<Method> forNameIgnoreCaseAndParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forNameIgnoreCase(methodName), MethodMatcherUtil.forParameterTypes(parameterTypes));
    }

    public static Predicate<Method> forNameIgnoreCaseAndStrictParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forNameIgnoreCase(methodName), MethodMatcherUtil.forStrictParameterTypes(parameterTypes));
    }

    public static Predicate<Method> forMethodSignature(Method method) {
        Objects.requireNonNull(method);
        return MethodMatcherUtil.forMethodSignature(method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public static Predicate<Method> forMethodSignature(String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Predicate<Method> resultMatcher = Objects.isNull(returnType) ? MethodMatcherUtil.forNoneReturnType() : MethodMatcherUtil.forReturnType(returnType);
        Predicate<Method> parameterMatcher = Objects.isNull(parameterTypes) ? MethodMatcherUtil.forNoneParameter() : MethodMatcherUtil.forParameterTypes(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forName(methodName), resultMatcher, parameterMatcher);
    }

    public static Predicate<Method> forStrictMethodSignature(String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Predicate<Method> resultMatcher = Objects.isNull(returnType) ? MethodMatcherUtil.forNoneReturnType() : MethodMatcherUtil.forReturnType(returnType);
        Predicate<Method> parameterMatcher = Objects.isNull(parameterTypes) ? MethodMatcherUtil.forNoneParameter() : MethodMatcherUtil.forStrictParameterTypes(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forName(methodName), resultMatcher, parameterMatcher);
    }

    public static Predicate<Method> forStrictMethodSignature(Method method) {
        Objects.requireNonNull(method);
        return MethodMatcherUtil.forMethodSignature(method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public static Predicate<Method> forName(String methodName) {
        return method -> Objects.equals(method.getName(), methodName);
    }

    public static Predicate<Method> forNameIgnoreCase(String methodName) {
        return method -> CharSequenceUtil.endWithIgnoreCase(method.getName(), methodName);
    }

    public static Predicate<Method> forNoneReturnType() {
        return method -> Objects.equals(method.getReturnType(), Void.TYPE);
    }

    public static Predicate<Method> forReturnType(Class<?> returnType) {
        return method -> ClassUtil.isAssignable(returnType, method.getReturnType());
    }

    public static Predicate<Method> forStrictReturnType(Class<?> returnType) {
        return method -> Objects.equals(method.getReturnType(), returnType);
    }

    public static Predicate<Method> forNoneParameter() {
        return method -> method.getParameterCount() == 0;
    }

    public static Predicate<Method> forParameterCount(int count) {
        return method -> method.getParameterCount() == count;
    }

    public static Predicate<Method> forParameterTypes(Class<?> ... parameterTypes) {
        Objects.requireNonNull(parameterTypes);
        return method -> ClassUtil.isAllAssignableFrom(parameterTypes, method.getParameterTypes());
    }

    public static Predicate<Method> forMostSpecificParameterTypes(Class<?> ... parameterTypes) {
        return MethodMatcherUtil.mostSpecificStrictParameterTypesMatcher(parameterTypes, ClassUtil::isAssignable);
    }

    public static Predicate<Method> forMostSpecificStrictParameterTypes(Class<?> ... parameterTypes) {
        return MethodMatcherUtil.mostSpecificStrictParameterTypesMatcher(parameterTypes, Objects::equals);
    }

    public static Predicate<Method> forStrictParameterTypes(Class<?> ... parameterTypes) {
        Objects.requireNonNull(parameterTypes);
        return method -> ArrayUtil.equals(method.getParameterTypes(), parameterTypes);
    }

    @NotNull
    private static Predicate<Method> mostSpecificStrictParameterTypesMatcher(Class<?>[] parameterTypes, BiPredicate<Class<?>, Class<?>> typeMatcher) {
        Objects.requireNonNull(parameterTypes);
        if (parameterTypes.length == 0) {
            return MethodMatcherUtil.forNoneParameter();
        }
        return method -> {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            if (parameterTypes.length > methodParameterTypes.length) {
                return false;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class parameterType = parameterTypes[i];
                if (Objects.isNull(parameterType) || !typeMatcher.negate().test(parameterType, methodParameterTypes[i])) continue;
                return false;
            }
            return true;
        };
    }
}

