/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.SerializeUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.StrUtil;

public class ObjUtil {
    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 instanceof Number && obj2 instanceof Number) {
            return NumberUtil.equals((Number)obj1, (Number)obj2);
        }
        if (ArrayUtil.isArray(obj1) && ArrayUtil.isArray(obj2)) {
            return ArrayUtil.equals(obj1, obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    public static boolean notEquals(Object obj1, Object obj2) {
        return !ObjUtil.equals(obj1, obj2);
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        int count = 0;
        if (obj instanceof Iterator || obj instanceof Iterable) {
            Iterator iter;
            Iterator iterator = iter = obj instanceof Iterator ? (Iterator)obj : ((Iterable)obj).iterator();
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).containsValue(element);
        }
        if (obj instanceof Iterator || obj instanceof Iterable) {
            Iterator iter;
            Iterator iterator = iter = obj instanceof Iterator ? (Iterator)obj : ((Iterable)obj).iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ObjUtil.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!ObjUtil.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (ArrayUtil.isArray(obj)) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!ObjUtil.equals(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Collection) {
            return CollUtil.isEmpty((Collection)obj);
        }
        if (obj instanceof Map) {
            return MapUtil.isEmpty((Map)obj);
        }
        if (obj instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)obj);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.isEmpty(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !ObjUtil.isEmpty(obj);
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return ObjUtil.isNull(object) ? defaultValue : object;
    }

    public static <T> T defaultIfNull(T source, Supplier<? extends T> defaultSupplier) {
        if (ObjUtil.isNotNull(source)) {
            return source;
        }
        return defaultSupplier.get();
    }

    public static <T, R> R defaultIfNull(T source, Function<? super T, ? extends R> handler, Supplier<? extends R> defaultSupplier) {
        if (ObjUtil.isNotNull(source)) {
            return handler.apply(source);
        }
        return defaultSupplier.get();
    }

    public static <T, R> R apply(T source, Function<T, R> handler) {
        return ObjUtil.defaultIfNull(source, handler, null);
    }

    public static <T, R> R defaultIfNull(T source, Function<? super T, ? extends R> handler, R defaultValue) {
        return ObjUtil.isNull(source) ? defaultValue : handler.apply(source);
    }

    public static <T> T clone(T obj) {
        T result = ArrayUtil.clone(obj);
        if (null != result) {
            return result;
        }
        if (obj instanceof Cloneable) {
            try {
                return MethodUtil.invoke(obj, "clone", new Object[0]);
            }
            catch (HutoolException e) {
                if (e.getCause() instanceof IllegalAccessException) {
                    return ObjUtil.cloneByStream(obj);
                }
                throw e;
            }
        }
        return ObjUtil.cloneByStream(obj);
    }

    public static <T> T cloneIfPossible(T obj) {
        Object clone = null;
        try {
            clone = ObjUtil.clone(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)(clone == null ? obj : clone);
    }

    public static <T> T cloneByStream(T obj) {
        return SerializeUtil.clone(obj);
    }

    public static boolean isBasicType(Object object) {
        if (null == object) {
            return false;
        }
        return ClassUtil.isBasicType(object.getClass());
    }

    public static boolean isValidIfNumber(Object obj) {
        if (obj instanceof Number) {
            return NumberUtil.isValidNumber((Number)obj);
        }
        return true;
    }

    public static Class<?> getTypeArgument(Object obj) {
        return ObjUtil.getTypeArgument(obj, 0);
    }

    public static Class<?> getTypeArgument(Object obj, int index) {
        return ClassUtil.getTypeArgument(obj.getClass(), index);
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return "null";
        }
        if (obj instanceof Map) {
            return obj.toString();
        }
        return Convert.toStr(obj);
    }
}

