/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection;

import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.codec.hash.Hash32;
import org.dromara.hutool.core.collection.CollectionOperation;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.TransCollection;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.collection.iter.IteratorEnumeration;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.collection.set.UniqueKeySet;
import org.dromara.hutool.core.comparator.CompareUtil;
import org.dromara.hutool.core.comparator.PinyinComparator;
import org.dromara.hutool.core.comparator.PropertyComparator;
import org.dromara.hutool.core.convert.CompositeConverter;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.func.SerBiConsumer;
import org.dromara.hutool.core.func.SerConsumer3;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.stream.StreamUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.StrValidator;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class CollUtil {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IterUtil.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return IterUtil.isEmpty(iterator);
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || !enumeration.hasMoreElements();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapUtil.isEmpty(map);
    }

    public static <T extends Collection<E>, E> T defaultIfEmpty(T collection, T defaultCollection) {
        return CollUtil.isEmpty(collection) ? defaultCollection : collection;
    }

    public static <T extends Collection<E>, E> T defaultIfEmpty(T collection, Function<T, T> handler, Supplier<? extends T> defaultSupplier) {
        return (T)(CollUtil.isEmpty(collection) ? (Collection)defaultSupplier.get() : (Collection)handler.apply(collection));
    }

    public static <T> Set<T> emptyIfNull(Set<T> set) {
        return ObjUtil.defaultIfNull(set, Collections.emptySet());
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        return ObjUtil.defaultIfNull(list, Collections.emptyList());
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollUtil.isEmpty(collection);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IterUtil.isNotEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return IterUtil.isNotEmpty(iterator);
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static boolean hasNull(Iterable<?> iterable) {
        return IterUtil.hasNull(IterUtil.getIter(iterable));
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapUtil.isNotEmpty(map);
    }

    public static <T> ArrayList<T> distinct(Collection<T> collection) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection));
    }

    public static <T, K> List<T> distinct(Collection<T> collection, Function<T, K> uniqueGenerator, boolean override) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        UniqueKeySet<K, T> set = new UniqueKeySet<K, T>(true, uniqueGenerator);
        if (override) {
            set.addAll(collection);
        } else {
            set.addAllIfAbsent(collection);
        }
        return new ArrayList(set);
    }

    @SafeVarargs
    public static <T> Collection<T> union(Collection<? extends T> ... colls) {
        return CollectionOperation.of(colls).union();
    }

    @SafeVarargs
    public static <T> Set<T> unionDistinct(Collection<? extends T> ... colls) {
        return CollectionOperation.of(colls).unionDistinct();
    }

    @SafeVarargs
    public static <T> List<T> unionAll(Collection<? extends T> ... colls) {
        return CollectionOperation.of(colls).unionAll();
    }

    @SafeVarargs
    public static <T> Collection<T> intersection(Collection<T> ... colls) {
        return CollectionOperation.of(colls).intersection();
    }

    @SafeVarargs
    public static <T> Set<T> intersectionDistinct(Collection<T> ... colls) {
        return CollectionOperation.of(colls).intersectionDistinct();
    }

    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        return CollectionOperation.of(coll1, coll2).disjunction();
    }

    public static <T> Collection<T> subtract(Collection<T> coll1, Collection<T> coll2) {
        if (CollUtil.isEmpty(coll1) || CollUtil.isEmpty(coll2)) {
            return coll1;
        }
        Collection<T> result = ObjUtil.clone(coll1);
        if (null == result) {
            result = CollUtil.create(coll1.getClass());
            result.addAll(coll1);
        }
        result.removeAll(coll2);
        return result;
    }

    public static <T> List<T> subtractToList(Collection<T> coll1, Collection<T> coll2) {
        return CollectionOperation.of(coll1, coll2).subtract();
    }

    public static boolean contains(Collection<?> collection, Object value) {
        return CollUtil.isNotEmpty(collection) && collection.contains(value);
    }

    public static boolean safeContains(Collection<?> collection, Object value) {
        try {
            return CollUtil.contains(collection, value);
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    public static <T> boolean contains(Collection<T> collection, Predicate<? super T> containFunc) {
        if (CollUtil.isEmpty(collection)) {
            return false;
        }
        for (T t : collection) {
            if (!containFunc.test(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollUtil.isEmpty(coll1) || CollUtil.isEmpty(coll2)) {
            return false;
        }
        boolean isFirstSmaller = coll1.size() <= coll2.size();
        Collection<?> smallerColl = isFirstSmaller ? coll1 : coll2;
        HashSet biggerSet = isFirstSmaller ? new HashSet(coll2) : new HashSet(coll1);
        for (Object object : smallerColl) {
            if (!biggerSet.contains(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection<?> coll1, Collection<?> coll2) {
        if (CollUtil.isEmpty(coll1)) {
            return CollUtil.isEmpty(coll2);
        }
        if (CollUtil.isEmpty(coll2)) {
            return true;
        }
        if (coll1 instanceof Set) {
            return coll1.containsAll(coll2);
        }
        Iterator<?> it = coll1.iterator();
        HashSet elementsAlreadySeen = new HashSet(coll1.size(), 1.0f);
        for (Object nextElement : coll2) {
            if (elementsAlreadySeen.contains(nextElement)) continue;
            boolean foundCurrentElement = false;
            while (it.hasNext()) {
                Object p = it.next();
                elementsAlreadySeen.add(p);
                if (!Objects.equals(nextElement, p)) continue;
                foundCurrentElement = true;
                break;
            }
            if (foundCurrentElement) continue;
            return false;
        }
        return true;
    }

    public static <T> Map<T, Integer> countMap(Iterable<T> collection) {
        return IterUtil.countMap(IterUtil.getIter(collection));
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, Function<T, ? extends CharSequence> func) {
        return IterUtil.join(IterUtil.getIter(iterable), conjunction, func);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.join(iterable.iterator(), conjunction);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, String prefix, String suffix) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.join(iterable.iterator(), conjunction, prefix, suffix);
    }

    public static <T> List<T> popPart(Stack<T> surplusAlaDatas, int partSize) {
        if (CollUtil.isEmpty(surplusAlaDatas)) {
            return ListUtil.empty();
        }
        int size = surplusAlaDatas.size();
        int popSize = Math.min(partSize, size);
        ArrayList<T> resultList = new ArrayList<T>(popSize);
        for (int i = 0; i < popSize; ++i) {
            resultList.add(surplusAlaDatas.pop());
        }
        return resultList;
    }

    public static <T> List<T> popPart(Deque<T> surplusAlaDatas, int partSize) {
        if (CollUtil.isEmpty(surplusAlaDatas)) {
            return ListUtil.empty();
        }
        int size = surplusAlaDatas.size();
        int popSize = Math.min(partSize, size);
        ArrayList<T> resultList = new ArrayList<T>(popSize);
        for (int i = 0; i < popSize; ++i) {
            resultList.add(surplusAlaDatas.pop());
        }
        return resultList;
    }

    public static <T> BlockingQueue<T> newBlockingQueue(int capacity, boolean isLinked) {
        AbstractQueue queue = isLinked ? new LinkedBlockingDeque(capacity) : new ArrayBlockingQueue(capacity);
        return queue;
    }

    public static <E, T extends Collection<E>> T empty(Class<?> collectionClass) {
        if (null == collectionClass) {
            return (T)Collections.emptyList();
        }
        if (Set.class.isAssignableFrom(collectionClass)) {
            if (NavigableSet.class == collectionClass) {
                return (T)Collections.emptyNavigableSet();
            }
            if (SortedSet.class == collectionClass) {
                return (T)Collections.emptySortedSet();
            }
            return (T)Collections.emptySet();
        }
        if (List.class.isAssignableFrom(collectionClass)) {
            return (T)Collections.emptyList();
        }
        throw new IllegalArgumentException(StrUtil.format("[{}] is not support to get empty!", collectionClass));
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        return CollUtil.create(collectionType, null);
    }

    public static <T> Collection<T> create(Class<?> collectionType, Class<T> elementType) {
        Collection<Object> list;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet((o1, o2) -> {
                if (o1 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return CompareUtil.compare(o1.toString(), o2.toString());
            });
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            list = EnumSet.noneOf(Assert.notNull(elementType));
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)ConstructorUtil.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                Class<?> superclass = collectionType.getSuperclass();
                if (null != superclass && collectionType != superclass) {
                    return CollUtil.create(superclass);
                }
                throw ExceptionUtil.wrapRuntime(e);
            }
        }
        return list;
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        return ListUtil.sub(list, start, end);
    }

    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        return ListUtil.sub(list, start, end, step);
    }

    public static <T> List<T> sub(Collection<T> collection, int start, int end) {
        return CollUtil.sub(collection, start, end, 1);
    }

    public static <T> List<T> sub(Collection<T> collection, int start, int end, int step) {
        if (CollUtil.isEmpty(collection)) {
            return ListUtil.empty();
        }
        ArrayList<T> list = collection instanceof List ? (ArrayList<T>)collection : ListUtil.of(collection);
        return CollUtil.sub(list, start, end, step);
    }

    public static <T> List<List<T>> partition(Collection<T> collection, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollUtil.isEmpty(collection)) {
            return result;
        }
        int initSize = Math.min(collection.size(), size);
        ArrayList<T> subList = new ArrayList<T>(initSize);
        for (T t : collection) {
            if (subList.size() >= size) {
                result.add(subList);
                subList = new ArrayList(initSize);
            }
            subList.add(t);
        }
        result.add(subList);
        return result;
    }

    public static <T extends Collection<E>, E> T edit(T collection, UnaryOperator<E> editor) {
        if (null == collection || null == editor) {
            return collection;
        }
        Collection<T> collection2 = CollUtil.create(collection.getClass());
        if (CollUtil.isEmpty(collection)) {
            return (T)collection2;
        }
        for (E t : collection) {
            Object modified = editor.apply(t);
            if (null == modified) continue;
            collection2.add(modified);
        }
        return (T)collection2;
    }

    public static <T extends Collection<E>, E> T filter(T collection, Predicate<E> predicate) {
        if (null == collection || null == predicate) {
            return collection;
        }
        return CollUtil.edit(collection, t -> predicate.test(t) ? t : null);
    }

    public static <T extends Collection<E>, E> T removeAny(T collection, E ... elesRemoved) {
        collection.removeAll(SetUtil.of(elesRemoved));
        return collection;
    }

    public static <T extends Iterable<E>, E> T remove(T iter, Predicate<E> predicate) {
        if (null == iter) {
            return null;
        }
        IterUtil.remove(iter.iterator(), predicate);
        return iter;
    }

    public static <T extends Collection<E>, E> T removeNull(T collection) {
        return CollUtil.remove(collection, Objects::isNull);
    }

    public static <T extends Collection<E>, E extends CharSequence> T removeEmpty(T collection) {
        return CollUtil.remove(collection, StrValidator::isEmpty);
    }

    public static <T extends Collection<E>, E extends CharSequence> T removeBlank(T collection) {
        return CollUtil.remove(collection, StrValidator::isBlank);
    }

    public static <T extends Collection<E>, E> T removeWithAddIf(T targetCollection, T resultCollection, Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        Iterator<E> each = targetCollection.iterator();
        while (each.hasNext()) {
            E next = each.next();
            if (!predicate.test(next)) continue;
            resultCollection.add(next);
            each.remove();
        }
        return resultCollection;
    }

    public static <T extends Collection<E>, E> List<E> removeWithAddIf(T targetCollection, Predicate<? super E> predicate) {
        ArrayList removed = new ArrayList();
        CollUtil.removeWithAddIf(targetCollection, removed, predicate);
        return removed;
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<? super T, ? extends R> func) {
        return CollUtil.map(collection, func, true);
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<? super T, ? extends R> mapper, boolean ignoreNull) {
        if (ignoreNull) {
            return StreamUtil.of(collection).filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return StreamUtil.of(collection).map(mapper).collect(Collectors.toList());
    }

    public static Collection<Object> getFieldValues(Iterable<?> collection, String fieldName) {
        return CollUtil.getFieldValues(collection, fieldName, false);
    }

    public static List<Object> getFieldValues(Iterable<?> collection, String fieldName, boolean ignoreNull) {
        return CollUtil.map(collection, bean -> {
            if (bean instanceof Map) {
                return ((Map)bean).get(fieldName);
            }
            return FieldUtil.getFieldValue(bean, fieldName);
        }, ignoreNull);
    }

    public static <T> List<T> getFieldValues(Iterable<?> collection, String fieldName, Class<T> elementType) {
        Collection<Object> fieldValues = CollUtil.getFieldValues(collection, fieldName);
        return Convert.toList(elementType, fieldValues);
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterable<V> iterable, String fieldName) {
        return IterUtil.fieldValueMap(IterUtil.getIter(iterable), fieldName);
    }

    public static <K, V> Map<K, V> fieldValueAsMap(Iterable<?> iterable, String fieldNameForKey, String fieldNameForValue) {
        return IterUtil.fieldValueAsMap(IterUtil.getIter(iterable), fieldNameForKey, fieldNameForValue);
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            return CollUtil.isEmpty(list) ? null : (T)list.get(0);
        }
        return IterUtil.getFirst(IterUtil.getIter(iterable));
    }

    public static <T> T getFirstNoneNull(Iterable<T> iterable) {
        return IterUtil.getFirstNoneNull(IterUtil.getIter(iterable));
    }

    public static <T> T getFirst(Iterable<T> collection, Predicate<T> predicate) {
        return IterUtil.getFirst(IterUtil.getIter(collection), predicate);
    }

    public static <T> T getFirstByField(Iterable<T> collection, String fieldName, Object fieldValue) {
        return (T)CollUtil.getFirst(collection, t -> {
            if (t instanceof Map) {
                Map map = (Map)t;
                Object value = map.get(fieldName);
                return ObjUtil.equals(value, fieldValue);
            }
            Object value = FieldUtil.getFieldValue(t, fieldName);
            return ObjUtil.equals(value, fieldValue);
        });
    }

    public static <T> int count(Iterable<T> iterable, Predicate<T> predicate) {
        int count = 0;
        if (null != iterable) {
            for (T t : iterable) {
                if (null != predicate && !predicate.test(t)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T> int indexOf(Collection<T> collection, Predicate<T> predicate) {
        if (CollUtil.isNotEmpty(collection)) {
            int index = 0;
            for (T t : collection) {
                if (null == predicate || predicate.test(t)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(Collection<T> collection, Predicate<? super T> predicate) {
        if (collection instanceof List) {
            return ListUtil.lastIndexOf((List)collection, predicate);
        }
        int matchIndex = -1;
        if (CollUtil.isNotEmpty(collection)) {
            int index = 0;
            for (T t : collection) {
                if (null == predicate || predicate.test(t)) {
                    matchIndex = index;
                }
                ++index;
            }
        }
        return matchIndex;
    }

    public static <T> int[] indexOfAll(Collection<T> collection, Predicate<T> predicate) {
        return Convert.convert(int[].class, CollUtil.indexListOfAll(collection, predicate));
    }

    public static <T> List<Integer> indexListOfAll(Collection<T> collection, Predicate<T> predicate) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (null != collection) {
            int index = 0;
            for (T t : collection) {
                if (null == predicate || predicate.test(t)) {
                    indexList.add(index);
                }
                ++index;
            }
        }
        return indexList;
    }

    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        return ArrayUtil.zip(SplitUtil.splitToArray(keys, delimiter), SplitUtil.splitToArray(values, delimiter), isOrder);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter) {
        return CollUtil.zip(keys, values, delimiter, false);
    }

    public static <K, V> Map<K, V> zip(Collection<K> keys, Collection<V> values) {
        int entryCount;
        if (CollUtil.isEmpty(keys) || CollUtil.isEmpty(values)) {
            return MapUtil.empty();
        }
        HashMap<K, V> map = MapUtil.newHashMap(entryCount);
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        for (entryCount = Math.min(keys.size(), values.size()); entryCount > 0; --entryCount) {
            map.put(keyIterator.next(), valueIterator.next());
        }
        return map;
    }

    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        treeSet.addAll(collection);
        return treeSet;
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<E> iter) {
        return new IteratorEnumeration<E>(Objects.requireNonNull(iter));
    }

    public static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : ListUtil.of(IterUtil.getIter(iterable));
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        return MapUtil.toListMap(mapList);
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        return MapUtil.toMapList(listMap);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value) {
        return CollUtil.addAll(collection, value, TypeUtil.getTypeArgument(collection.getClass()));
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType) {
        Iterator<Object> iter;
        if (null == collection || null == value) {
            return collection;
        }
        if (TypeUtil.isUnknown((Type)elementType)) {
            elementType = Object.class;
        }
        if (value instanceof CharSequence) {
            String arrayStr = StrUtil.unWrap((CharSequence)value, '[', ']');
            iter = SplitUtil.splitTrim(arrayStr, ",").iterator();
        } else {
            iter = value instanceof Map && BeanUtil.isWritableBean(TypeUtil.getClass((Type)elementType)) ? new ArrayIter<Object>(new Object[]{value}) : IterUtil.getIter(value);
        }
        CompositeConverter convert = CompositeConverter.getInstance();
        while (iter.hasNext()) {
            collection.add(convert.convert((Type)elementType, iter.next()));
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterator<T> iterator) {
        if (null != collection && null != iterator) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterable<T> iterable) {
        if (iterable == null) {
            return collection;
        }
        return CollUtil.addAll(collection, iterable.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T[] values) {
        if (null != collection && null != values) {
            Collections.addAll(collection, values);
        }
        return collection;
    }

    public static <T> T getLast(Collection<T> collection) {
        return CollUtil.get(collection, -1);
    }

    public static <T> T get(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size || index < 0) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        return IterUtil.get(collection.iterator(), index);
    }

    public static <T> List<T> getAny(Collection<T> collection, int ... indexes) {
        if (CollUtil.isEmpty(collection) || ArrayUtil.isEmpty(indexes)) {
            return ListUtil.zero();
        }
        int size = collection.size();
        ArrayList<Object> result = new ArrayList<Object>(indexes.length);
        if (collection instanceof List) {
            List list = (List)collection;
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(list.get(index));
            }
        } else {
            Object[] array = collection.toArray();
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(array[index]);
            }
        }
        return result;
    }

    @SafeVarargs
    public static <T> List<T> sortPageAll(int pageNo, int pageSize, Comparator<T> comparator, Collection<T> ... colls) {
        ArrayList<T> list = new ArrayList<T>(pageNo * pageSize);
        for (Collection<T> coll : colls) {
            list.addAll(coll);
        }
        if (null != comparator) {
            list.sort(comparator);
        }
        return ListUtil.page(list, pageNo, pageSize);
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        return ListUtil.sort(list, c);
    }

    public static <T> List<T> sortByProperty(Collection<T> collection, String property) {
        return CollUtil.sort(collection, new PropertyComparator(property));
    }

    public static <T> List<T> sortByProperty(List<T> list, String property) {
        return ListUtil.sortByProperty(list, property);
    }

    public static List<String> sortByPinyin(Collection<String> collection) {
        return CollUtil.sort(collection, new PinyinComparator());
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListUtil.sortByPinyin(list);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(map);
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortToMap(Collection<Map.Entry<K, V>> entryCollection, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(entryCollection);
        list.sort(comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortByEntry(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        return CollUtil.sortToMap(map.entrySet(), comparator);
    }

    public static <K, V> List<Map.Entry<K, V>> sortEntryToList(Collection<Map.Entry<K, V>> collection) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(collection);
        list.sort((o1, o2) -> {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1 instanceof Comparable) {
                return ((Comparable)v1).compareTo(v2);
            }
            return v1.toString().compareTo(v2.toString());
        });
        return list;
    }

    public static <T> void forEach(Iterable<T> iterable, SerBiConsumer<T, Integer> consumer) {
        if (iterable == null) {
            return;
        }
        CollUtil.forEach(iterable.iterator(), consumer);
    }

    public static <T> void forEach(Iterator<T> iterator, SerBiConsumer<T, Integer> consumer) {
        if (iterator == null) {
            return;
        }
        int index = 0;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), index);
            ++index;
        }
    }

    public static <T> void forEach(Enumeration<T> enumeration, SerBiConsumer<T, Integer> consumer) {
        if (enumeration == null) {
            return;
        }
        int index = 0;
        while (enumeration.hasMoreElements()) {
            consumer.accept(enumeration.nextElement(), index);
            ++index;
        }
    }

    public static <K, V> void forEach(Map<K, V> map, SerConsumer3<K, V, Integer> kvConsumer) {
        if (map == null) {
            return;
        }
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            kvConsumer.accept(entry.getKey(), entry.getValue(), index);
            ++index;
        }
    }

    public static <T> List<List<T>> group(Collection<T> collection, Hash32<T> hash) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollUtil.isEmpty(collection)) {
            return result;
        }
        if (null == hash) {
            hash = t -> null == t ? 0 : t.hashCode();
        }
        for (T t2 : collection) {
            int index = hash.hash32(t2);
            if (result.size() - 1 < index) {
                while (result.size() - 1 < index) {
                    result.add(null);
                }
                result.set(index, ListUtil.of(t2));
                continue;
            }
            List subList = (List)result.get(index);
            if (null == subList) {
                result.set(index, ListUtil.of(t2));
                continue;
            }
            subList.add(t2);
        }
        return result;
    }

    public static <T> List<List<T>> groupByField(Collection<T> collection, String fieldName) {
        return CollUtil.groupByFunc(collection, t -> BeanUtil.getFieldValue(t, fieldName));
    }

    public static <T> List<List<T>> groupByFunc(Collection<T> collection, final Function<T, ?> getter) {
        return CollUtil.group(collection, new Hash32<T>(){
            private final List<Object> hashValList = new ArrayList<Object>();

            @Override
            public int hash32(T t) {
                if (null == t || !BeanUtil.isWritableBean(t.getClass())) {
                    return 0;
                }
                Object value = getter.apply(t);
                int hash = this.hashValList.indexOf(value);
                if (hash < 0) {
                    this.hashValList.add(value);
                    hash = this.hashValList.size() - 1;
                }
                return hash;
            }
        });
    }

    public static <K> Set<K> keySet(Collection<Map<K, ?>> mapCollection) {
        if (CollUtil.isEmpty(mapCollection)) {
            return new HashSet();
        }
        HashSet<K> set = new HashSet<K>(mapCollection.size() * 16);
        for (Map<K, ?> map : mapCollection) {
            set.addAll(map.keySet());
        }
        return set;
    }

    public static <V> List<V> values(Collection<Map<?, V>> mapCollection) {
        if (CollUtil.isEmpty(mapCollection)) {
            return ListUtil.zero();
        }
        int size = 0;
        for (Map<?, V> map : mapCollection) {
            size += map.size();
        }
        if (size == 0) {
            return ListUtil.zero();
        }
        ArrayList<V> values = new ArrayList<V>(size);
        for (Map<?, V> map : mapCollection) {
            values.addAll(map.values());
        }
        return values;
    }

    public static <T extends Comparable<? super T>> T max(Collection<T> coll) {
        return (T)(CollUtil.isEmpty(coll) ? null : (Comparable)Collections.max(coll));
    }

    public static <T extends Comparable<? super T>> T min(Collection<T> coll) {
        return (T)(CollUtil.isEmpty(coll) ? null : (Comparable)Collections.min(coll));
    }

    public static <T> Collection<T> view(Collection<? extends T> c) {
        if (null == c) {
            return null;
        }
        return Collections.unmodifiableCollection(c);
    }

    public static void clear(Collection<?> ... collections) {
        for (Collection<?> collection : collections) {
            if (!CollUtil.isNotEmpty(collection)) continue;
            collection.clear();
        }
    }

    public static <T> void padLeft(List<T> list, int minLen, T padObj) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            CollUtil.padRight(list, minLen, padObj);
            return;
        }
        if (list.size() >= minLen) {
            return;
        }
        if (list instanceof ArrayList) {
            list.addAll(0, Collections.nCopies(minLen - list.size(), padObj));
        } else {
            for (int i = list.size(); i < minLen; ++i) {
                list.add(0, padObj);
            }
        }
    }

    public static <T> void padRight(Collection<T> list, int minLen, T padObj) {
        Objects.requireNonNull(list);
        for (int i = list.size(); i < minLen; ++i) {
            list.add(padObj);
        }
    }

    public static <F, T> Collection<T> trans(Collection<F> collection, Function<? super F, ? extends T> function) {
        return new TransCollection<F, T>(collection, function);
    }

    public static <E, K, V> void setValueByMap(Iterable<E> iterable, Map<K, V> map, Function<E, K> keyGenerate, BiConsumer<E, V> biConsumer) {
        iterable.forEach(x -> Optional.ofNullable(map.get(keyGenerate.apply(x))).ifPresent(y -> biConsumer.accept(x, y)));
    }

    public static int size(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        if (object instanceof Iterable) {
            return IterUtil.size((Iterable)object);
        }
        if (object instanceof Iterator) {
            return IterUtil.size((Iterator)object);
        }
        if (object instanceof Enumeration) {
            int total = 0;
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                ++total;
                it.nextElement();
            }
            return total;
        }
        if (ArrayUtil.isArray(object)) {
            return ArrayUtil.length(object);
        }
        throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
    }

    public static boolean isSub(Collection<?> subCollection, Collection<?> collection) {
        if (CollUtil.size(subCollection) > CollUtil.size(collection)) {
            return false;
        }
        return IterUtil.isSub(subCollection, collection);
    }

    public static boolean isEqualList(Collection<?> list1, Collection<?> list2) {
        return CollUtil.equals(list1, list2, false);
    }

    public static boolean equals(Collection<?> coll1, Collection<?> coll2, boolean ignoreOrder) {
        if (CollUtil.size(coll1) != CollUtil.size(coll2)) {
            return false;
        }
        return IterUtil.equals(coll1, coll2, ignoreOrder);
    }

    public static <T, S extends T> boolean addIfAbsent(Collection<T> collection, S object) {
        if (object == null || collection == null || collection.contains(object)) {
            return false;
        }
        return collection.add(object);
    }

    public static <T> boolean anyMatch(Collection<T> collection, Predicate<T> predicate) {
        if (CollUtil.isEmpty(collection)) {
            return Boolean.FALSE;
        }
        return collection.stream().anyMatch(predicate);
    }

    public static <T> boolean allMatch(Collection<T> collection, Predicate<T> predicate) {
        if (CollUtil.isEmpty(collection)) {
            return Boolean.FALSE;
        }
        return collection.stream().allMatch(predicate);
    }

    public static <T> List<T> flat(Collection<?> collection) {
        return CollUtil.flat(collection, true);
    }

    public static <T> List<T> flat(Collection<?> collection, boolean skipNull) {
        LinkedList queue = new LinkedList(collection);
        ArrayList result = new ArrayList();
        while (CollUtil.isNotEmpty(queue)) {
            Object t = queue.removeFirst();
            if (skipNull && t == null) continue;
            if (t instanceof Collection) {
                queue.addAll((Collection)t);
                continue;
            }
            result.add(t);
        }
        return result;
    }
}

