/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.dromara.hutool.core.convert.AbstractConverter;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.date.SqlDateUtil;
import org.dromara.hutool.core.text.StrUtil;

public class DateConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final DateConverter INSTANCE = new DateConverter();
    private String format;

    public DateConverter() {
        this(null);
    }

    public DateConverter(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Class<?> targetClass, Object value) {
        DateTime date;
        if (value == null || value instanceof CharSequence && StrUtil.isBlank(value.toString())) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return this.wrap(targetClass, DateUtil.date((TemporalAccessor)value));
        }
        if (value instanceof Calendar) {
            return this.wrap(targetClass, DateUtil.date((Calendar)value));
        }
        if (null == this.format && value instanceof Number) {
            return this.wrap(targetClass, ((Number)value).longValue());
        }
        String valueStr = this.convertToStr(value);
        DateTime dateTime = date = StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr) : DateUtil.parse((CharSequence)valueStr, this.format);
        if (null != date) {
            return this.wrap(targetClass, date);
        }
        throw new ConvertException("Can not convert {}:[{}] to {}", value.getClass().getName(), value, targetClass.getName());
    }

    private Date wrap(Class<?> targetClass, Date date) {
        if (targetClass == date.getClass()) {
            return date;
        }
        return this.wrap(targetClass, date.getTime());
    }

    private Date wrap(Class<?> targetClass, long mills) {
        if (Date.class == targetClass) {
            return new Date(mills);
        }
        if (DateTime.class == targetClass) {
            return DateUtil.date(mills);
        }
        return SqlDateUtil.wrap(targetClass, mills);
    }
}

