/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.array;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.dromara.hutool.core.array.ArrayWrapper;
import org.dromara.hutool.core.array.PrimitiveArrayUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.collection.set.UniqueKeySet;
import org.dromara.hutool.core.comparator.CompareUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrJoiner;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.StrValidator;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.core.util.RandomUtil;

public class ArrayUtil
extends PrimitiveArrayUtil {
    public static <A> A castOrWrapSingle(Object values, Class<?> elementType) {
        if (ArrayUtil.isArray(values)) {
            return (A)values;
        }
        return ArrayUtil.wrapSingle(values, elementType);
    }

    public static <A> A wrapSingle(Object value, Class<?> elementType) {
        Object newInstance = Array.newInstance(null == elementType ? value.getClass() : elementType, 1);
        Array.set(newInstance, 0, value);
        return (A)newInstance;
    }

    public static <T> T[] ofArray(Iterable<T> iterable, Class<T> componentType) {
        if (null == iterable) {
            return ArrayUtil.newArray(componentType, 0);
        }
        if (iterable instanceof List) {
            return ((List)iterable).toArray(ArrayUtil.newArray(componentType, 0));
        }
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            T[] result = ArrayUtil.newArray(componentType, size);
            int i = 0;
            for (T element : iterable) {
                result[i] = element;
                ++i;
            }
        }
        return ListUtil.of(iterable.iterator()).toArray(ArrayUtil.newArray(componentType, 0));
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return !ArrayUtil.hasBlank(args);
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StrUtil.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        return ArrayUtil.isEmpty(array) ? defaultArray : array;
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (ArrayUtil.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static int emptyCount(Object ... args) {
        int count = 0;
        if (ArrayUtil.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjUtil.isEmpty(element)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T> boolean hasEmpty(T[] args) {
        if (ArrayUtil.isNotEmpty(args)) {
            for (T element : args) {
                if (!ObjUtil.isEmpty(element)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean hasEmptyVarargs(T ... args) {
        return ArrayUtil.hasEmpty(args);
    }

    public static <T> boolean isAllEmpty(T[] args) {
        for (T obj : args) {
            if (ObjUtil.isEmpty(obj)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> boolean isAllEmptyVarargs(T ... args) {
        return ArrayUtil.isAllEmpty(args);
    }

    public static boolean isAllNotEmpty(Object ... args) {
        return !ArrayUtil.hasEmpty(args);
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (T element : array) {
                if (!ObjUtil.isNull(element)) continue;
                return true;
            }
        }
        return array == null;
    }

    public static <T> boolean isAllNull(T ... array) {
        return null == ArrayUtil.firstNonNull(array);
    }

    public static <T> boolean isAllNotNull(T ... array) {
        return !ArrayUtil.hasNull(array);
    }

    public static <T> boolean hasNonNull(T ... array) {
        return null != ArrayUtil.firstNonNull(array);
    }

    public static <T> T firstNonNull(T ... array) {
        if (ArrayUtil.isEmpty(array)) {
            return null;
        }
        return (T)ArrayUtil.firstMatch(ObjUtil::isNotNull, array);
    }

    public static <T> T firstMatch(Predicate<T> matcher, T ... array) {
        int index = ArrayUtil.matchIndex(matcher, array);
        if (index == -1) {
            return null;
        }
        return array[index];
    }

    public static <T> int matchIndex(Predicate<T> matcher, T ... array) {
        return ArrayUtil.matchIndex(0, matcher, array);
    }

    public static <E> int matchIndex(int beginIndexInclude, Predicate<E> matcher, E ... array) {
        if (ArrayUtil.isEmpty(array)) {
            return -1;
        }
        ArrayWrapper<E[], E> arrayWrapper = ArrayWrapper.of(array);
        return arrayWrapper.matchIndex(beginIndexInclude, matcher);
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Object[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static Class<?> getComponentType(Object array) {
        return null == array ? null : ArrayUtil.getComponentType(array.getClass());
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Object[] cast(Class<?> type, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        Object[] result = ArrayUtil.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayUtil.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayUtil.insert(buffer, buffer.length, newElements);
    }

    @SafeVarargs
    public static <A, T> A append(A array, T ... newElements) {
        if (ArrayUtil.isEmpty(array)) {
            if (null == array) {
                return (A)newElements;
            }
            return (A)ConvertUtil.convert(array.getClass(), newElements);
        }
        return ArrayUtil.insert(array, ArrayUtil.length(array), newElements);
    }

    public static <T> T[] setOrAppend(T[] array, int index, T value) {
        if (ArrayUtil.isEmpty(array)) {
            return (Object[])ArrayUtil.wrapSingle(value, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).setOrAppend(index, value).getRaw();
    }

    public static <A> A setOrAppend(A array, int index, Object value) {
        if (ArrayUtil.isEmpty(array)) {
            return ArrayUtil.wrapSingle(value, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).setOrAppend(index, value).getRaw();
    }

    public static <A> A setOrPadding(A array, int index, Object value) {
        if (index == 0 && ArrayUtil.isEmpty(array)) {
            return ArrayUtil.wrapSingle(value, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).setOrPadding(index, value).getRaw();
    }

    public static <A, E> A setOrPadding(A array, int index, E value, E paddingValue) {
        if (index == 0 && ArrayUtil.isEmpty(array)) {
            return ArrayUtil.wrapSingle(value, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).setOrPadding(index, value, paddingValue).getRaw();
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (!ArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        T[] result = ArrayUtil.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        if (length == 0) {
            return result;
        }
        length = 0;
        for (T[] array : arrays) {
            if (!ArrayUtil.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static <T> T[] replace(T[] array, int index, T ... values) {
        if (ArrayUtil.isEmpty(array)) {
            return values;
        }
        return ArrayWrapper.of(array).replace(index, values).getRaw();
    }

    public static <A> A replace(A array, int index, A values) {
        if (ArrayUtil.isEmpty(array)) {
            return ArrayUtil.castOrWrapSingle(values, null == array ? null : array.getClass().getComponentType());
        }
        return ArrayWrapper.of(array).replace(index, values).getRaw();
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return ArrayUtil.insert(buffer, index, newElements);
    }

    @SafeVarargs
    public static <A, E> A insert(A array, int index, E ... newElements) {
        return (A)ArrayWrapper.of(array).insertArray(index, newElements).getRaw();
    }

    public static <T> T[] resize(T[] data, int newSize, Class<?> componentType) {
        if (newSize < 0) {
            return data;
        }
        T[] newArray = ArrayUtil.newArray(componentType, newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(data)) {
            System.arraycopy(data, 0, newArray, 0, Math.min(data.length, newSize));
        }
        return newArray;
    }

    public static Object resize(Object array, int newSize) {
        if (newSize < 0) {
            return array;
        }
        if (null == array) {
            return null;
        }
        int length = ArrayUtil.length(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(array)) {
            System.arraycopy(array, 0, newArray, 0, Math.min(length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayUtil.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    public static <T> T copy(Object src, T dest) {
        return ArrayUtil.copy(src, dest, ArrayUtil.length(src));
    }

    public static <T> T copy(Object src, T dest, int length) {
        return ArrayUtil.copy(src, 0, dest, 0, length);
    }

    public static <T> T copy(Object src, int srcPos, T dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                ArrayUtil.copy(obj, result, length);
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T[] edit(T[] array, UnaryOperator<T> editor) {
        if (null == array || null == editor) {
            return array;
        }
        ArrayList list = new ArrayList(array.length);
        for (T t : array) {
            Object modified = editor.apply(t);
            if (null == modified) continue;
            list.add(modified);
        }
        T[] result = ArrayUtil.newArray(array.getClass().getComponentType(), list.size());
        return list.toArray(result);
    }

    public static <T> T[] filter(T[] array, Predicate<T> predicate) {
        if (null == array || null == predicate) {
            return array;
        }
        return ArrayUtil.edit(array, t -> predicate.test(t) ? t : null);
    }

    public static <T> T[] removeNull(T[] array) {
        return ArrayUtil.edit(array, UnaryOperator.identity());
    }

    public static <T extends CharSequence> T[] removeEmpty(T[] array) {
        return ArrayUtil.filter(array, StrValidator::isNotEmpty);
    }

    public static <T extends CharSequence> T[] removeBlank(T[] array) {
        return ArrayUtil.filter(array, StrValidator::isNotBlank);
    }

    public static String[] nullToEmpty(String[] array) {
        return ArrayUtil.edit(array, t -> null == t ? "" : t);
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        if (ArrayUtil.isEmpty(keys) || ArrayUtil.isEmpty(values)) {
            return MapUtil.newHashMap(0, isOrder);
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = MapUtil.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values) {
        return ArrayUtil.zip(keys, values, false);
    }

    public static <T> int indexOf(T[] array, Object value, int beginIndexInclude) {
        return ArrayWrapper.of(array).indexOf(value, beginIndexInclude);
    }

    public static <T> int indexOf(T[] array, Object value) {
        return ArrayWrapper.of(array).indexOf(value);
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (!StrUtil.equalsIgnoreCase(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, Object value) {
        if (ArrayUtil.isEmpty(array)) {
            return -1;
        }
        return ArrayUtil.lastIndexOf(array, value, array.length - 1);
    }

    public static <T> int lastIndexOf(T[] array, Object value, int endInclude) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (int i = endInclude; i >= 0; --i) {
                if (!ObjUtil.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static <T> boolean containsAny(T[] array, T ... values) {
        for (T value : values) {
            if (!ArrayUtil.contains(array, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... values) {
        for (T value : values) {
            if (ArrayUtil.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return ArrayUtil.indexOfIgnoreCase(array, value) > -1;
    }

    public static Object[] wrap(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayUtil.wrap((long[])obj);
                    }
                    case "int": {
                        return ArrayUtil.wrap((int[])obj);
                    }
                    case "short": {
                        return ArrayUtil.wrap((short[])obj);
                    }
                    case "char": {
                        return ArrayUtil.wrap((char[])obj);
                    }
                    case "byte": {
                        return ArrayUtil.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ArrayUtil.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ArrayUtil.wrap((float[])obj);
                    }
                    case "double": {
                        return ArrayUtil.wrap((double[])obj);
                    }
                }
                return (Object[])obj;
            }
            catch (Exception e) {
                throw ExceptionUtil.wrapRuntime(e);
            }
        }
        throw new HutoolException(StrUtil.format("[{}] is not Array!", obj.getClass()));
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static <E> E get(Object array, int index) {
        return ArrayWrapper.of(array).get(index);
    }

    public static <E> E get(E[] array, Predicate<E> predicate) {
        for (E e : array) {
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    public static <T> T[] getAny(Object array, int ... indexes) {
        if (null == array) {
            return null;
        }
        if (null == indexes) {
            return ArrayUtil.newArray(array.getClass().getComponentType(), 0);
        }
        T[] result = ArrayUtil.newArray(array.getClass().getComponentType(), indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            result[i] = ArrayUtil.get(array, indexes[i]);
        }
        return result;
    }

    public static String toString(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return ArrayUtil.join(array, conjunction, null, null);
    }

    public static <T> String join(T[] array, CharSequence delimiter, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        return StrJoiner.of(delimiter, prefix, suffix).setWrapElement(true).append(array).toString();
    }

    public static <T> String join(T[] array, CharSequence conjunction, UnaryOperator<T> editor) {
        return StrJoiner.of(conjunction).append(ArrayUtil.edit(array, editor)).toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        if (!ArrayUtil.isArray(array)) {
            throw new IllegalArgumentException(StrUtil.format("[{}] is not a Array!", array.getClass()));
        }
        return StrJoiner.of(conjunction).append(array).toString();
    }

    public static <T> T[] remove(T[] array, int index) throws IllegalArgumentException {
        return (Object[])ArrayUtil.remove(array, index);
    }

    public static <T> T[] removeEle(T[] array, T element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static <T> T[] reverse(T[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <T> T[] reverse(T[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayUtil.min(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray, Comparator<T> comparator) {
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T min = numberArray[0];
        for (T t : numberArray) {
            if (CompareUtil.compare(min, t, comparator) <= 0) continue;
            min = t;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ArrayUtil.max(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray, Comparator<T> comparator) {
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (CompareUtil.compare(max, numberArray[i], comparator) >= 0) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static <T> T[] shuffle(T[] array) {
        return ArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static <T> T[] shuffle(T[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            ArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static <T> T[] swap(T[] array, int index1, int index2) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        T tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static Object swap(Object array, int index1, int index2) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        Object tmp = ArrayUtil.get(array, index1);
        Array.set(array, index1, Array.get(array, index2));
        Array.set(array, index2, tmp);
        return array;
    }

    public static <T> T[] distinct(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        LinkedHashSet set = new LinkedHashSet(array.length, 1.0f);
        Collections.addAll(set, array);
        return ArrayUtil.ofArray(set, ArrayUtil.getComponentType(array));
    }

    public static <T, K> T[] distinct(T[] array, Function<T, K> uniqueGenerator, boolean override) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        UniqueKeySet<K, T> set = new UniqueKeySet<K, T>(true, uniqueGenerator);
        if (override) {
            Collections.addAll(set, array);
        } else {
            for (T t : array) {
                set.addIfAbsent(t);
            }
        }
        return ArrayUtil.ofArray(set, ArrayUtil.getComponentType(array));
    }

    public static <R> R[] map(Object array, Class<R> targetComponentType, Function<?, ? extends R> func) {
        int length = ArrayUtil.length(array);
        T[] result = ArrayUtil.newArray(targetComponentType, length);
        for (int i = 0; i < length; ++i) {
            result[i] = func.apply(ArrayUtil.get(array, i));
        }
        return result;
    }

    public static <T, R> R[] mapToArray(T[] array, Function<? super T, ? extends R> func, IntFunction<R[]> generator) {
        return Arrays.stream(array).map(func).toArray(generator);
    }

    public static <T, R> List<R> mapToList(T[] array, Function<? super T, ? extends R> func) {
        return Arrays.stream(array).map(func).collect(Collectors.toList());
    }

    public static <T, R> Set<R> mapToSet(T[] array, Function<? super T, ? extends R> func) {
        return Arrays.stream(array).map(func).collect(Collectors.toSet());
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (ArrayUtil.hasNull(array1, array2)) {
            return false;
        }
        Assert.isTrue(ArrayUtil.isArray(array1), "First is not a Array !", new Object[0]);
        Assert.isTrue(ArrayUtil.isArray(array2), "Second is not a Array !", new Object[0]);
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])array1, (Object[])array2);
    }

    public static <T> T[] sub(T[] array, int start, int end) {
        Assert.notNull(array, "array must be not null !", new Object[0]);
        int length = ArrayUtil.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (start >= length) {
            return ArrayUtil.newArray(array.getClass().getComponentType(), 0);
        }
        if (end > length) {
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static <A> A sub(A array, int beginInclude, int endExclude) {
        return ArrayWrapper.of(array).getSub(beginInclude, endExclude);
    }

    public static <A> A sub(A array, int beginInclude, int endExclude, int step) {
        return ArrayWrapper.of(array).getSub(beginInclude, endExclude, step);
    }

    public static <T> boolean isSub(T[] array, T[] subArray) {
        return ArrayUtil.indexOfSub(array, subArray) > -1;
    }

    public static <T> int indexOfSub(T[] array, T[] subArray) {
        return ArrayUtil.indexOfSub(array, 0, subArray);
    }

    public static <T> int indexOfSub(T[] array, int beginInclude, T[] subArray) {
        if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray) || subArray.length > array.length) {
            return -1;
        }
        int firstIndex = ArrayUtil.indexOf(array, subArray[0], beginInclude);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjUtil.equals(array[i + firstIndex], subArray[i])) continue;
            return ArrayUtil.indexOfSub(array, firstIndex + 1, subArray);
        }
        return firstIndex;
    }

    public static <T> int lastIndexOfSub(T[] array, T[] subArray) {
        if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray)) {
            return -1;
        }
        return ArrayUtil.lastIndexOfSub(array, array.length - 1, subArray);
    }

    public static <T> int lastIndexOfSub(T[] array, int endInclude, T[] subArray) {
        if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray) || subArray.length > array.length || endInclude < 0) {
            return -1;
        }
        int firstIndex = ArrayUtil.lastIndexOf(array, subArray[0], endInclude);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjUtil.equals(array[i + firstIndex], subArray[i])) continue;
            return ArrayUtil.lastIndexOfSub(array, firstIndex - 1, subArray);
        }
        return firstIndex;
    }

    public static <T> boolean isSorted(T[] array, Comparator<? super T> comparator) {
        if (ArrayUtil.isEmpty(array) || null == comparator) {
            return false;
        }
        int size = array.length - 1;
        int cmp = comparator.compare(array[0], array[size]);
        if (cmp < 0) {
            return ArrayUtil.isSortedASC(array, comparator);
        }
        if (cmp > 0) {
            return ArrayUtil.isSortedDESC(array, comparator);
        }
        for (int i = 0; i < size; ++i) {
            if (comparator.compare(array[i], array[i + 1]) == 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        int size = array.length - 1;
        int cmp = array[0].compareTo(array[size]);
        if (cmp < 0) {
            return ArrayUtil.isSortedASC(array);
        }
        if (cmp > 0) {
            return ArrayUtil.isSortedDESC(array);
        }
        for (int i = 0; i < size; ++i) {
            if (array[i].compareTo(array[i + 1]) == 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSortedASC(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        int size = array.length - 1;
        for (int i = 0; i < size; ++i) {
            if (array[i].compareTo(array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSortedDESC(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        int size = array.length - 1;
        for (int i = 0; i < size; ++i) {
            if (array[i].compareTo(array[i + 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isSortedASC(T[] array, Comparator<? super T> comparator) {
        if (ArrayUtil.isEmpty(array) || null == comparator) {
            return false;
        }
        int size = array.length - 1;
        for (int i = 0; i < size; ++i) {
            if (comparator.compare(array[i], array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isSortedDESC(T[] array, Comparator<? super T> comparator) {
        if (ArrayUtil.isEmpty(array) || null == comparator) {
            return false;
        }
        int size = array.length - 1;
        for (int i = 0; i < size; ++i) {
            if (comparator.compare(array[i], array[i + 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> Boolean hasSameElement(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        HashSet<T> elementSet = SetUtil.of(Arrays.asList(array));
        return elementSet.size() != array.length;
    }

    public static <T> boolean startWith(T[] array, T[] prefix) {
        if (array == prefix) {
            return true;
        }
        if (ArrayUtil.isEmpty(array)) {
            return ArrayUtil.isEmpty(prefix);
        }
        if (prefix.length > array.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (!ObjUtil.notEquals(array[i], prefix[i])) continue;
            return false;
        }
        return true;
    }
}

