/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean;

import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanDesc;
import org.dromara.hutool.core.bean.RecordBeanDesc;
import org.dromara.hutool.core.bean.RecordUtil;
import org.dromara.hutool.core.bean.SimpleBeanDesc;
import org.dromara.hutool.core.bean.StrictBeanDesc;
import org.dromara.hutool.core.map.reference.WeakConcurrentMap;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.JdkProxyUtil;

public class BeanDescFactory {
    private static final WeakConcurrentMap<Class<?>, BeanDesc> bdCache = new WeakConcurrentMap();

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return bdCache.computeIfAbsent(clazz, key -> BeanDescFactory.getBeanDescWithoutCache(clazz));
    }

    public static BeanDesc getBeanDescWithoutCache(Class<?> clazz) {
        if (RecordUtil.isRecord(clazz)) {
            return new RecordBeanDesc(clazz);
        }
        if (JdkProxyUtil.isProxyClass(clazz) || ArrayUtil.isEmpty(FieldUtil.getFields(clazz))) {
            return new SimpleBeanDesc(clazz);
        }
        return new StrictBeanDesc(clazz);
    }

    public static void clearCache() {
        bdCache.clear();
    }
}

