/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.path.node;

import org.dromara.hutool.core.bean.DynaBean;
import org.dromara.hutool.core.bean.path.node.Node;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.text.StrUtil;

public class NameNode
implements Node {
    private final String name;

    public NameNode(String name) {
        this.name = name;
    }

    public boolean isNumber() {
        return NumberUtil.isInteger(this.name);
    }

    @Override
    public Object getValue(Object bean) {
        if (null == bean) {
            return null;
        }
        if ("$".equals(this.name)) {
            return bean;
        }
        Object value = DynaBean.of(bean).get(this.name);
        if (null == value && StrUtil.lowerFirst(ClassUtil.getClassName(bean, true)).equals(this.name)) {
            value = bean;
        }
        return value;
    }

    @Override
    public Object setValue(Object bean, Object value) {
        return DynaBean.of(bean).set(this.name, value).getBean();
    }

    public String toString() {
        return this.name;
    }
}

