/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.XMLGregorianCalendar;
import org.dromara.hutool.core.collection.set.ConcurrentHashSet;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.convert.MatcherConverter;
import org.dromara.hutool.core.convert.impl.AtomicBooleanConverter;
import org.dromara.hutool.core.convert.impl.AtomicIntegerArrayConverter;
import org.dromara.hutool.core.convert.impl.AtomicLongArrayConverter;
import org.dromara.hutool.core.convert.impl.AtomicReferenceConverter;
import org.dromara.hutool.core.convert.impl.BooleanConverter;
import org.dromara.hutool.core.convert.impl.CalendarConverter;
import org.dromara.hutool.core.convert.impl.CharacterConverter;
import org.dromara.hutool.core.convert.impl.CharsetConverter;
import org.dromara.hutool.core.convert.impl.CurrencyConverter;
import org.dromara.hutool.core.convert.impl.DurationConverter;
import org.dromara.hutool.core.convert.impl.LocaleConverter;
import org.dromara.hutool.core.convert.impl.OptConverter;
import org.dromara.hutool.core.convert.impl.OptionalConverter;
import org.dromara.hutool.core.convert.impl.PairConverter;
import org.dromara.hutool.core.convert.impl.PathConverter;
import org.dromara.hutool.core.convert.impl.PeriodConverter;
import org.dromara.hutool.core.convert.impl.ReferenceConverter;
import org.dromara.hutool.core.convert.impl.StackTraceElementConverter;
import org.dromara.hutool.core.convert.impl.StringConverter;
import org.dromara.hutool.core.convert.impl.TemporalAccessorConverter;
import org.dromara.hutool.core.convert.impl.TimeZoneConverter;
import org.dromara.hutool.core.convert.impl.TripleConverter;
import org.dromara.hutool.core.convert.impl.TupleConverter;
import org.dromara.hutool.core.convert.impl.URIConverter;
import org.dromara.hutool.core.convert.impl.URLConverter;
import org.dromara.hutool.core.convert.impl.UUIDConverter;
import org.dromara.hutool.core.convert.impl.XMLGregorianCalendarConverter;
import org.dromara.hutool.core.convert.impl.ZoneIdConverter;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.lang.tuple.Pair;
import org.dromara.hutool.core.lang.tuple.Triple;
import org.dromara.hutool.core.lang.tuple.Tuple;
import org.dromara.hutool.core.map.concurrent.SafeConcurrentHashMap;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.stream.StreamUtil;

public class RegisterConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile Set<MatcherConverter> converterSet;
    private volatile Map<Type, Converter> customConverterMap;
    private Map<Class<?>, Converter> defaultConverterMap;

    public static RegisterConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public RegisterConverter() {
        this.registerDefault();
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, value, true);
        if (null != converter) {
            return converter.convert(targetType, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, targetType.getTypeName());
    }

    public Converter getConverter(Type type, Object value, boolean isCustomFirst) {
        Converter converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type, value);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type, value);
            }
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public Converter getDefaultConverter(Type type) {
        Class<?> key = null == type ? null : TypeUtil.getClass(type);
        return null == this.defaultConverterMap || null == key ? null : this.defaultConverterMap.get(key);
    }

    public Converter getCustomConverter(Type type, Object value) {
        return StreamUtil.of(this.converterSet).filter(predicate -> predicate.match(type, value)).findFirst().orElse(null);
    }

    public Converter getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter register(Type type, Converter converter) {
        if (null == this.customConverterMap) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new SafeConcurrentHashMap<Type, Converter>();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter register(MatcherConverter converter) {
        if (null == this.converterSet) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.converterSet) {
                    this.converterSet = new ConcurrentHashSet<MatcherConverter>();
                }
            }
        }
        this.converterSet.add(converter);
        return this;
    }

    private void registerDefault() {
        SafeConcurrentHashMap defaultConverterMap = new SafeConcurrentHashMap(64);
        defaultConverterMap.put(Character.class, CharacterConverter.INSTANCE);
        defaultConverterMap.put(Boolean.class, BooleanConverter.INSTANCE);
        defaultConverterMap.put(AtomicBoolean.class, AtomicBooleanConverter.INSTANCE);
        StringConverter stringConverter = new StringConverter();
        defaultConverterMap.put(CharSequence.class, stringConverter);
        defaultConverterMap.put(String.class, stringConverter);
        defaultConverterMap.put(URI.class, new URIConverter());
        defaultConverterMap.put(URL.class, new URLConverter());
        defaultConverterMap.put(Calendar.class, new CalendarConverter());
        defaultConverterMap.put(XMLGregorianCalendar.class, new XMLGregorianCalendarConverter());
        defaultConverterMap.put(TemporalAccessor.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(Instant.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(LocalDateTime.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(LocalDate.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(LocalTime.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(ZonedDateTime.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(OffsetDateTime.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(OffsetTime.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(DayOfWeek.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(Month.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(MonthDay.class, TemporalAccessorConverter.INSTANCE);
        defaultConverterMap.put(Period.class, new PeriodConverter());
        defaultConverterMap.put(Duration.class, new DurationConverter());
        defaultConverterMap.put(WeakReference.class, ReferenceConverter.INSTANCE);
        defaultConverterMap.put(SoftReference.class, ReferenceConverter.INSTANCE);
        defaultConverterMap.put(AtomicReference.class, new AtomicReferenceConverter());
        defaultConverterMap.put(AtomicIntegerArray.class, new AtomicIntegerArrayConverter());
        defaultConverterMap.put(AtomicLongArray.class, new AtomicLongArrayConverter());
        defaultConverterMap.put(TimeZone.class, new TimeZoneConverter());
        defaultConverterMap.put(ZoneId.class, new ZoneIdConverter());
        defaultConverterMap.put(Locale.class, new LocaleConverter());
        defaultConverterMap.put(Charset.class, new CharsetConverter());
        defaultConverterMap.put(Path.class, new PathConverter());
        defaultConverterMap.put(Currency.class, new CurrencyConverter());
        defaultConverterMap.put(UUID.class, new UUIDConverter());
        defaultConverterMap.put(StackTraceElement.class, new StackTraceElementConverter());
        defaultConverterMap.put(Optional.class, new OptionalConverter());
        defaultConverterMap.put(Opt.class, new OptConverter());
        defaultConverterMap.put(Pair.class, PairConverter.INSTANCE);
        defaultConverterMap.put(Triple.class, TripleConverter.INSTANCE);
        defaultConverterMap.put(Tuple.class, TupleConverter.INSTANCE);
        this.defaultConverterMap = defaultConverterMap;
    }

    private static class SingletonHolder {
        private static final RegisterConverter INSTANCE = new RegisterConverter();

        private SingletonHolder() {
        }
    }
}

