/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.convert.CompositeConverter;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.lang.tuple.Triple;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.reflect.TypeUtil;

public class TripleConverter
implements Converter {
    public static final TripleConverter INSTANCE = new TripleConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type leftType = TypeUtil.getTypeArgument(targetType, 0);
        Type middileType = TypeUtil.getTypeArgument(targetType, 1);
        Type rightType = TypeUtil.getTypeArgument(targetType, 2);
        return this.convert(leftType, middileType, rightType, value);
    }

    public Triple<?, ?, ?> convert(Type leftType, Type middleType, Type rightType, Object value) throws ConvertException {
        Map<String, Object> map = null;
        if (value instanceof Map) {
            map = (Map<String, Object>)value;
        } else if (BeanUtil.isReadableBean(value.getClass())) {
            map = BeanUtil.toBeanMap(value);
        }
        if (null != map) {
            return TripleConverter.mapToTriple(leftType, middleType, rightType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    private static Triple<?, ?, ?> mapToTriple(Type leftType, Type middleType, Type rightType, Map map) {
        Object left = map.get("left");
        Object middle = map.get("middle");
        Object right = map.get("right");
        CompositeConverter convert = CompositeConverter.getInstance();
        return Triple.of(TypeUtil.isUnknown(leftType) ? left : convert.convert(leftType, left), TypeUtil.isUnknown(middleType) ? middle : convert.convert(middleType, middle), TypeUtil.isUnknown(rightType) ? right : convert.convert(rightType, right));
    }
}

