/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date.format.parser;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.date.DateBuilder;
import org.dromara.hutool.core.date.DateException;
import org.dromara.hutool.core.date.Month;
import org.dromara.hutool.core.date.Week;
import org.dromara.hutool.core.date.format.parser.DateParser;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.CharUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.dfa.WordTree;

public class RegexDateParser
implements DateParser,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int[] NSS = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final Pattern ZONE_OFFSET_PATTERN = Pattern.compile("[-+]\\d{1,2}:?(?:\\d{2})?");
    private static final WordTree ZONE_TREE = WordTree.of(TimeZone.getAvailableIDs());
    private final List<Pattern> patterns;
    private boolean preferMonthFirst;

    public static RegexDateParser of(String ... regexes) {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>(regexes.length);
        for (String regex : regexes) {
            patternList.add(Pattern.compile(regex, 2));
        }
        return new RegexDateParser(patternList);
    }

    public static RegexDateParser of(Pattern ... patterns) {
        return new RegexDateParser(ListUtil.of(patterns));
    }

    public RegexDateParser(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    public void setPreferMonthFirst(boolean preferMonthFirst) {
        this.preferMonthFirst = preferMonthFirst;
    }

    public RegexDateParser addRegex(String regex) {
        return this.addPattern(Pattern.compile(regex, 2));
    }

    public RegexDateParser addPattern(Pattern pattern) {
        this.patterns.add(pattern);
        return this;
    }

    @Override
    public Date parse(CharSequence source) throws DateException {
        Assert.notBlank(source, "Date str must be not blank!", new Object[0]);
        return this.parseToBuilder(source).toDate();
    }

    public LocalDateTime parseToLocalDateTime(CharSequence source) throws DateException {
        Assert.notBlank(source, "Date str must be not blank!", new Object[0]);
        return this.parseToBuilder(source).toLocalDateTime();
    }

    public OffsetDateTime parseToOffsetDateTime(CharSequence source) throws DateException {
        Assert.notBlank(source, "Date str must be not blank!", new Object[0]);
        return this.parseToBuilder(source).toOffsetDateTime();
    }

    private DateBuilder parseToBuilder(CharSequence source) throws DateException {
        DateBuilder dateBuilder = DateBuilder.of();
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(source);
            if (!matcher.matches()) continue;
            this.parse(matcher, dateBuilder);
            return dateBuilder;
        }
        throw new DateException("No valid pattern for date string: [{}]", source);
    }

    private void parse(Matcher matcher, DateBuilder dateBuilder) throws DateException {
        String number = ReUtil.group(matcher, "number");
        if (StrUtil.isNotEmpty(number)) {
            RegexDateParser.parseNumberDate(number, dateBuilder);
            return;
        }
        String millisecond = ReUtil.group(matcher, "millisecond");
        if (StrUtil.isNotEmpty(millisecond)) {
            dateBuilder.setMillisecond(RegexDateParser.parseLong(millisecond));
            return;
        }
        Opt.ofNullable(ReUtil.group(matcher, "year")).ifPresent(year -> dateBuilder.setYear(RegexDateParser.parseYear(year)));
        Opt.ofNullable(ReUtil.group(matcher, "dayOrMonth")).ifPresent(dayOrMonth -> RegexDateParser.parseDayOrMonth(dayOrMonth, dateBuilder, this.preferMonthFirst));
        Opt.ofNullable(ReUtil.group(matcher, "month")).ifPresent(month -> dateBuilder.setMonth(RegexDateParser.parseMonth(month)));
        Opt.ofNullable(ReUtil.group(matcher, "week")).ifPresent(week -> dateBuilder.setWeek(RegexDateParser.parseWeek(week)));
        Opt.ofNullable(ReUtil.group(matcher, "day")).ifPresent(day -> dateBuilder.setDay(RegexDateParser.parseNumberLimit(day, 1, 31)));
        Opt.ofNullable(ReUtil.group(matcher, "hour")).ifPresent(hour -> dateBuilder.setHour(RegexDateParser.parseNumberLimit(hour, 0, 23)));
        Opt.ofNullable(ReUtil.group(matcher, "minute")).ifPresent(minute -> dateBuilder.setMinute(RegexDateParser.parseNumberLimit(minute, 0, 59)));
        Opt.ofNullable(ReUtil.group(matcher, "second")).ifPresent(second -> dateBuilder.setSecond(RegexDateParser.parseNumberLimit(second, 0, 59)));
        Opt.ofNullable(ReUtil.group(matcher, "ns")).ifPresent(ns -> dateBuilder.setNs(RegexDateParser.parseNano(ns)));
        Opt.ofNullable(ReUtil.group(matcher, "m")).ifPresent(m -> {
            if (CharUtil.equals('p', m.charAt(0), true)) {
                dateBuilder.setPm(true);
            } else {
                dateBuilder.setAm(true);
            }
        });
        Opt.ofNullable(ReUtil.group(matcher, "zero")).ifPresent(zero -> {
            dateBuilder.setZoneOffsetSetted(true);
            dateBuilder.setZoneOffset(0);
        });
        Opt.ofNullable(ReUtil.group(matcher, "zone")).ifPresent(zoneOffset -> RegexDateParser.parseZone(zoneOffset, dateBuilder));
        Opt.ofNullable(ReUtil.group(matcher, "zoneOffset")).ifPresent(zoneOffset -> {
            dateBuilder.setZoneOffsetSetted(true);
            dateBuilder.setZoneOffset(RegexDateParser.parseZoneOffset(zoneOffset));
        });
        Opt.ofNullable(ReUtil.group(matcher, "unixsecond")).ifPresent(unixsecond -> dateBuilder.setUnixsecond(RegexDateParser.parseLong(unixsecond)));
    }

    private static void parseNumberDate(String number, DateBuilder dateBuilder) {
        int length = number.length();
        switch (length) {
            case 4: {
                dateBuilder.setYear(Integer.parseInt(number));
                break;
            }
            case 6: {
                dateBuilder.setYear(RegexDateParser.parseInt(number, 0, 4));
                dateBuilder.setMonth(RegexDateParser.parseInt(number, 4, 6));
                break;
            }
            case 8: {
                dateBuilder.setYear(RegexDateParser.parseInt(number, 0, 4));
                dateBuilder.setMonth(RegexDateParser.parseInt(number, 4, 6));
                dateBuilder.setDay(RegexDateParser.parseInt(number, 6, 8));
                break;
            }
            case 14: {
                dateBuilder.setYear(RegexDateParser.parseInt(number, 0, 4));
                dateBuilder.setMonth(RegexDateParser.parseInt(number, 4, 6));
                dateBuilder.setDay(RegexDateParser.parseInt(number, 6, 8));
                dateBuilder.setHour(RegexDateParser.parseInt(number, 8, 10));
                dateBuilder.setMinute(RegexDateParser.parseInt(number, 10, 12));
                dateBuilder.setSecond(RegexDateParser.parseInt(number, 12, 14));
                break;
            }
            case 10: {
                dateBuilder.setUnixsecond(RegexDateParser.parseLong(number));
                break;
            }
            case 13: {
                dateBuilder.setMillisecond(RegexDateParser.parseLong(number));
                break;
            }
            case 16: {
                dateBuilder.setUnixsecond(RegexDateParser.parseLong(number.substring(0, 10)));
                dateBuilder.setNs(RegexDateParser.parseInt(number, 10, 16));
                break;
            }
            case 19: {
                dateBuilder.setUnixsecond(RegexDateParser.parseLong(number.substring(0, 10)));
                dateBuilder.setNs(RegexDateParser.parseInt(number, 10, 19));
            }
        }
    }

    private static int parseYear(String year) {
        int length = year.length();
        switch (length) {
            case 4: {
                return Integer.parseInt(year);
            }
            case 2: {
                int num = Integer.parseInt(year);
                return (num > 50 ? 1900 : 2000) + num;
            }
        }
        throw new DateException("Invalid year: [{}]", year);
    }

    private static void parseDayOrMonth(String dayOrMonth, DateBuilder dateBuilder, boolean preferMonthFirst) {
        int b;
        int a;
        char next = dayOrMonth.charAt(1);
        if (next < '0' || next > '9') {
            a = RegexDateParser.parseInt(dayOrMonth, 0, 1);
            b = RegexDateParser.parseInt(dayOrMonth, 2, dayOrMonth.length());
        } else {
            a = RegexDateParser.parseInt(dayOrMonth, 0, 2);
            b = RegexDateParser.parseInt(dayOrMonth, 3, dayOrMonth.length());
        }
        if (a > 31 || b > 31 || a == 0 || b == 0 || a > 12 && b > 12) {
            throw new DateException("Invalid DayOrMonth : {}", dayOrMonth);
        }
        if (b > 12 || preferMonthFirst && a <= 12) {
            dateBuilder.setMonth(a);
            dateBuilder.setDay(b);
        } else {
            dateBuilder.setMonth(b);
            dateBuilder.setDay(a);
        }
    }

    private static int parseMonth(String month) {
        try {
            int monthInt = Integer.parseInt(month);
            if (monthInt > 0 && monthInt < 13) {
                return monthInt;
            }
        }
        catch (NumberFormatException e) {
            return Month.of(month).getValueBaseOne();
        }
        throw new DateException("Invalid month: [{}]", month);
    }

    private static int parseWeek(String week) {
        return Week.of(week).getIso8601Value();
    }

    private static int parseNumberLimit(String numberStr, int minInclude, int maxInclude) {
        try {
            int monthInt = Integer.parseInt(numberStr);
            if (monthInt >= minInclude && monthInt <= maxInclude) {
                return monthInt;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new DateException("Invalid number: [{}]", numberStr);
    }

    private static long parseLong(String numberStr) {
        try {
            return Long.parseLong(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DateException("Invalid long: [{}]", numberStr);
        }
    }

    private static int parseInt(String numberStr, int from, int to) {
        try {
            return Integer.parseInt(numberStr.substring(from, to));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DateException("Invalid int: [{}]", numberStr);
        }
    }

    private static int parseNano(String ns) {
        return NSS[ns.length() - 1] * Integer.parseInt(ns);
    }

    private static void parseZone(String zone, DateBuilder dateBuilder) {
        String zoneOffset = ReUtil.getGroup0(ZONE_OFFSET_PATTERN, (CharSequence)zone);
        if (StrUtil.isNotBlank(zoneOffset)) {
            dateBuilder.setZoneOffsetSetted(true);
            dateBuilder.setZoneOffset(RegexDateParser.parseZoneOffset(zoneOffset));
            return;
        }
        String zoneName = ZONE_TREE.match(zone);
        if (StrUtil.isNotBlank(zoneName)) {
            dateBuilder.setZoneOffsetSetted(true);
            dateBuilder.setZone(TimeZone.getTimeZone(zoneName));
        }
    }

    private static int parseZoneOffset(String zoneOffset) {
        int hour;
        boolean neg;
        int from = 0;
        int to = zoneOffset.length();
        boolean bl = neg = '-' == zoneOffset.charAt(from);
        if (++from + 2 <= to && Character.isDigit(zoneOffset.charAt(from + 1))) {
            hour = RegexDateParser.parseInt(zoneOffset, from, from + 2);
            from += 2;
        } else {
            hour = RegexDateParser.parseInt(zoneOffset, from, from + 1);
            ++from;
        }
        if (from + 3 <= to && zoneOffset.charAt(from) == ':') {
            ++from;
        }
        int minute = 0;
        if (from + 2 <= to) {
            minute = RegexDateParser.parseInt(zoneOffset, from, from + 2);
        }
        return (hour * 60 + minute) * (neg ? -1 : 1);
    }
}

