/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanException;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.exception.CloneException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;

public class DynaBean
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private Object bean;

    public static DynaBean of(Class<?> beanClass, Object ... params) {
        return DynaBean.of(ConstructorUtil.newInstance(beanClass, params));
    }

    public static DynaBean of(Object bean) {
        return new DynaBean(bean);
    }

    public DynaBean(Object bean) {
        Assert.notNull(bean);
        if (bean instanceof DynaBean) {
            this.bean = ((DynaBean)bean).getBean();
            this.beanClass = ((DynaBean)bean).getBeanClass();
        } else if (bean instanceof Class) {
            this.bean = ConstructorUtil.newInstance((Class)bean, new Object[0]);
            this.beanClass = (Class)bean;
        } else {
            this.bean = bean;
            this.beanClass = ClassUtil.getClass(bean);
        }
    }

    public <T> T getProperty(String expression) {
        return BeanUtil.getProperty(this.bean, expression);
    }

    public <T> T get(String fieldName) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return (T)((Map)this.bean).get(fieldName);
        }
        if (this.bean instanceof Collection) {
            try {
                return CollUtil.get((Collection)this.bean, Integer.parseInt(fieldName));
            }
            catch (NumberFormatException e) {
                return (T)CollUtil.map((Collection)this.bean, beanEle -> DynaBean.of(beanEle).get(fieldName), false);
            }
        }
        if (ArrayUtil.isArray(this.bean)) {
            try {
                return (T)ArrayUtil.get(this.bean, Integer.parseInt(fieldName));
            }
            catch (NumberFormatException e) {
                return (T)ArrayUtil.map(this.bean, Object.class, beanEle -> DynaBean.of(beanEle).get(fieldName));
            }
        }
        PropDesc prop = BeanUtil.getBeanDesc(this.beanClass).getProp(fieldName);
        if (null == prop) {
            return null;
        }
        return (T)prop.getValue(this.bean, false);
    }

    public boolean containsProp(String fieldName) {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return ((Map)this.bean).containsKey(fieldName);
        }
        if (this.bean instanceof Collection) {
            return CollUtil.size(this.bean) > Integer.parseInt(fieldName);
        }
        return null != BeanUtil.getBeanDesc(this.beanClass).getProp(fieldName);
    }

    public <T> T safeGet(String fieldName) {
        try {
            return this.get(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DynaBean setProperty(String expression, Object value) {
        BeanUtil.setProperty(this.bean, expression, value);
        return this;
    }

    public DynaBean set(String fieldName, Object value) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            ((Map)this.bean).put(fieldName, value);
        } else if (this.bean instanceof List) {
            ListUtil.setOrPadding((List)this.bean, ConvertUtil.toInt(fieldName), value);
        } else if (ArrayUtil.isArray(this.bean)) {
            this.bean = ArrayUtil.setOrPadding(this.bean, ConvertUtil.toInt(fieldName), value);
        } else {
            PropDesc prop = BeanUtil.getBeanDesc(this.beanClass).getProp(fieldName);
            if (null == prop) {
                throw new BeanException("No public field or set method for '{}'", fieldName);
            }
            prop.setValue(this.bean, value, false, false);
        }
        return this;
    }

    public Object invoke(String methodName, Object ... params) {
        return MethodUtil.invoke(this.bean, methodName, params);
    }

    public <T> T getBean() {
        return (T)this.bean;
    }

    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynaBean other = (DynaBean)obj;
        if (this.bean == null) {
            return other.bean == null;
        }
        return this.bean.equals(other.bean);
    }

    public String toString() {
        return this.bean.toString();
    }

    public DynaBean clone() {
        try {
            return (DynaBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }
}

