/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.bean.copier.AbsCopier;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class BeanToMapCopier
extends AbsCopier<Object, Map> {
    private final Type targetType;

    public BeanToMapCopier(Object source, Map target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public Map copy() {
        CopyOptions copyOptions = this.copyOptions;
        Class<?> actualEditable = this.source.getClass();
        if (null != copyOptions.editable) {
            Assert.isTrue(copyOptions.editable.isInstance(this.source), "Source class [{}] not assignable to Editable class [{}]", actualEditable.getName(), copyOptions.editable.getName());
            actualEditable = copyOptions.editable;
        }
        Map<String, PropDesc> sourcePropDescMap = this.getBeanDesc(actualEditable).getPropMap(copyOptions.ignoreCase);
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(copyOptions.transientSupport)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source, copyOptions.ignoreError);
            if (!copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            MutableEntry<Object, Object> entry = copyOptions.editField(sFieldName, sValue);
            if (null == entry) {
                return;
            }
            sFieldName = StrUtil.toStringOrNull(entry.getKey());
            if (null == sFieldName) {
                return;
            }
            sValue = entry.getValue();
            Type[] typeArguments = TypeUtil.getTypeArguments(this.targetType);
            if (null != typeArguments && typeArguments.length > 1) {
                sValue = copyOptions.convertField(typeArguments[1], sValue);
            }
            if (null != sValue || !copyOptions.ignoreNullValue) {
                ((Map)this.target).put(sFieldName, sValue);
            }
        });
        return (Map)this.target;
    }
}

