/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.path;

import java.util.Iterator;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.path.DefaultNodeBeanFactory;
import org.dromara.hutool.core.bean.path.NodeBeanFactory;
import org.dromara.hutool.core.bean.path.node.Node;
import org.dromara.hutool.core.bean.path.node.NodeFactory;
import org.dromara.hutool.core.text.StrUtil;

public class BeanPath<T>
implements Iterator<BeanPath<T>> {
    private static final char[] EXP_CHARS = new char[]{'.', '[', ']'};
    private final Node node;
    private final String child;
    private final NodeBeanFactory<T> beanFactory;

    public static BeanPath<Object> of(String expression) {
        return new BeanPath<Object>(expression, DefaultNodeBeanFactory.INSTANCE);
    }

    public static <T> BeanPath<T> of(String expression, NodeBeanFactory<T> beanFactory) {
        return new BeanPath<T>(expression, beanFactory);
    }

    public BeanPath(String expression, NodeBeanFactory<T> beanFactory) {
        this.beanFactory = beanFactory;
        int length = expression.length();
        StringBuilder builder = new StringBuilder();
        boolean isNumStart = false;
        boolean isInWrap = false;
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if ('\'' == c) {
                isInWrap = !isInWrap;
                continue;
            }
            if (!isInWrap && ArrayUtil.contains(EXP_CHARS, c)) {
                if (']' == c) {
                    if (!isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find ']' but no '[' !", expression, i));
                    }
                    isNumStart = false;
                } else {
                    if (isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, i));
                    }
                    if ('[' == c) {
                        isNumStart = true;
                    }
                }
                if (builder.length() <= 0) continue;
                this.node = NodeFactory.createNode(builder.toString());
                this.child = StrUtil.nullIfEmpty(expression.substring(c == '[' ? i : i + 1));
                return;
            }
            builder.append(c);
        }
        if (isNumStart) {
            throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, length - 1));
        }
        this.node = NodeFactory.createNode(builder.toString());
        this.child = null;
    }

    public Node getNode() {
        return this.node;
    }

    public String getChild() {
        return this.child;
    }

    @Override
    public boolean hasNext() {
        return null != this.child;
    }

    @Override
    public BeanPath<T> next() {
        return new BeanPath<T>(this.child, this.beanFactory);
    }

    public Object getValue(T bean) {
        Object value = this.beanFactory.getValue(bean, this);
        if (null == value) {
            return null;
        }
        if (!this.hasNext()) {
            return value;
        }
        return ((BeanPath)this.next()).getValue(value);
    }

    public Object setValue(T bean, Object value) {
        Object newSubBean;
        NodeBeanFactory<T> beanFactory = this.beanFactory;
        if (!this.hasNext()) {
            return beanFactory.setValue(bean, value, this);
        }
        Object childBeanPath = this.next();
        Object subBean = beanFactory.getValue(bean, this);
        if (null == subBean) {
            subBean = beanFactory.create(bean, this);
            beanFactory.setValue(bean, subBean, this);
            subBean = beanFactory.getValue(bean, this);
        }
        if ((newSubBean = ((BeanPath)childBeanPath).setValue(subBean, value)) != subBean) {
            beanFactory.setValue(bean, newSubBean, this);
        }
        return bean;
    }

    public String toString() {
        return "BeanPath{node=" + this.node + ", child='" + this.child + '\'' + '}';
    }
}

