/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.compress;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dromara.hutool.core.compress.ZipResource;
import org.dromara.hutool.core.compress.ZipSecurityUtil;
import org.dromara.hutool.core.compress.ZipUtil;
import org.dromara.hutool.core.io.IoUtil;

public class ZipFileResource
implements ZipResource {
    private final ZipFile zipFile;

    public ZipFileResource(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public void read(Consumer<ZipEntry> consumer, int maxSizeDiff) {
        Enumeration<? extends ZipEntry> em = this.zipFile.entries();
        while (em.hasMoreElements()) {
            consumer.accept(ZipSecurityUtil.checkZipBomb(em.nextElement(), maxSizeDiff));
        }
    }

    @Override
    public InputStream get(String path) {
        ZipFile zipFile = this.zipFile;
        ZipEntry entry = zipFile.getEntry(path);
        if (null != entry) {
            return ZipUtil.getStream(zipFile, entry);
        }
        return null;
    }

    @Override
    public InputStream get(ZipEntry entry) {
        return ZipUtil.getStream(this.zipFile, entry);
    }

    @Override
    public void close() throws IOException {
        IoUtil.closeQuietly(this.zipFile);
    }
}

