/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.finder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.text.StrUtil;

public class MultiStrFinder {
    protected final Map<Character, Integer> charIndexMap = new HashMap<Character, Integer>();
    protected final int allCharSize;
    protected final Node root;
    int nodeSize;

    public static MultiStrFinder of(Collection<String> source) {
        return new MultiStrFinder(source);
    }

    public MultiStrFinder(Collection<String> source) {
        HashSet<String> stringSet = new HashSet<String>();
        HashSet charSet = new HashSet();
        for (String string : source) {
            stringSet.add(string);
            StrUtil.forEach(string, charSet::add);
        }
        this.allCharSize = charSet.size();
        int index = 0;
        for (Character c : charSet) {
            this.charIndexMap.put(c, index);
            ++index;
        }
        this.root = Node.createRoot(index);
        this.buildPrefixTree(stringSet);
        this.buildFail();
    }

    protected void buildPrefixTree(Collection<String> stringSst) {
        int nodeIndex = 1;
        for (String string : stringSst) {
            Node node = this.root;
            for (char c : string.toCharArray()) {
                boolean addValue = node.addValue(c, nodeIndex, this.charIndexMap);
                if (addValue) {
                    ++nodeIndex;
                }
                node = node.directRouter[this.getIndex(c)];
            }
            node.setEnd(string);
        }
        this.nodeSize = nodeIndex;
    }

    protected void buildFail() {
        LinkedList<Node> nodeQueue = new LinkedList<Node>();
        for (int i = 0; i < this.root.directRouter.length; ++i) {
            Node nextNode = this.root.directRouter[i];
            if (nextNode == null) {
                this.root.directRouter[i] = this.root;
                continue;
            }
            nextNode.fail = this.root;
            nodeQueue.addLast(nextNode);
        }
        while (!nodeQueue.isEmpty()) {
            Node parent = (Node)nodeQueue.removeFirst();
            for (int i = 0; i < parent.directRouter.length; ++i) {
                Node child = parent.directRouter[i];
                if (child == null) {
                    parent.directRouter[i] = parent.fail.directRouter[i];
                    continue;
                }
                child.fail = parent.fail.directRouter[i];
                nodeQueue.addLast(child);
                child.fail.failPre.add(child);
            }
        }
    }

    public Map<String, List<Integer>> findMatch(String text) {
        HashMap<String, List<Integer>> resultMap = new HashMap<String, List<Integer>>();
        char[] chars = text.toCharArray();
        Node currentNode = this.root;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            Integer index = this.charIndexMap.get(Character.valueOf(c));
            if (index == null) {
                currentNode = this.root;
                continue;
            }
            currentNode = currentNode.directRouter[index];
            if (!currentNode.isEnd) continue;
            resultMap.computeIfAbsent(currentNode.tagetString, k -> new ArrayList()).add(i - currentNode.tagetString.length() + 1);
        }
        return resultMap;
    }

    protected int getIndex(char c) {
        Integer i = this.charIndexMap.get(Character.valueOf(c));
        if (i == null) {
            return -1;
        }
        return i;
    }

    protected static class Node {
        public boolean isEnd = false;
        public String tagetString;
        public Node fail;
        public Node[] directRouter;
        public int nodeIndex;
        public char value;
        public List<Node> failPre = new ArrayList<Node>();

        public boolean addValue(char c, int nodeIndex, Map<Character, Integer> charIndex) {
            Integer index = charIndex.get(Character.valueOf(c));
            Node node = this.directRouter[index];
            if (node != null) {
                return false;
            }
            this.directRouter[index.intValue()] = node = new Node();
            node.nodeIndex = nodeIndex;
            node.directRouter = new Node[this.directRouter.length];
            node.value = c;
            return true;
        }

        public void setEnd(String string) {
            this.tagetString = string;
            this.isEnd = true;
        }

        public Node getNext(char c, Map<Character, Integer> charIndex) {
            Integer index = charIndex.get(Character.valueOf(c));
            if (index == null) {
                return null;
            }
            return this.directRouter[index];
        }

        public static Node createRoot(int allCharSize) {
            Node node = new Node();
            node.nodeIndex = 0;
            node.fail = node;
            node.directRouter = new Node[allCharSize];
            return node;
        }

        public String toString() {
            return this.value + ":" + this.nodeIndex;
        }
    }
}

