/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanException;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.bean.copier.AbsCopier;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class BeanToBeanCopier<S, T>
extends AbsCopier<S, T> {
    private final Type targetType;

    public BeanToBeanCopier(S source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Map<String, PropDesc> targetPropDescMap;
        CopyOptions copyOptions = this.copyOptions;
        Class<?> actualEditable = this.target.getClass();
        if (null != copyOptions.editable) {
            Assert.isTrue(copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), copyOptions.editable.getName());
            actualEditable = copyOptions.editable;
        }
        if (MapUtil.isEmpty(targetPropDescMap = this.getBeanDesc(actualEditable).getPropMap(copyOptions.ignoreCase))) {
            if (copyOptions.ignoreError) {
                return (T)this.target;
            }
            throw new BeanException("No properties for target: {}", actualEditable);
        }
        Map<String, PropDesc> sourcePropDescMap = this.getBeanDesc(this.source.getClass()).getPropMap(copyOptions.ignoreCase);
        if (MapUtil.isEmpty(sourcePropDescMap)) {
            if (copyOptions.ignoreError) {
                return (T)this.target;
            }
            throw new BeanException("No properties for source: {}", this.source.getClass());
        }
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(copyOptions.transientSupport)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source, copyOptions.ignoreError);
            if (!this.copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            MutableEntry<Object, Object> entry = copyOptions.editField(sFieldName, sValue);
            if (null == entry) {
                return;
            }
            sFieldName = StrUtil.toStringOrNull(entry.getKey());
            if (null == sFieldName) {
                return;
            }
            sValue = entry.getValue();
            PropDesc tDesc = copyOptions.findPropDesc(targetPropDescMap, (String)sFieldName);
            if (null == tDesc || !tDesc.isWritable(copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = TypeUtil.getActualType(this.targetType, tDesc.getFieldType());
            sValue = copyOptions.convertField(fieldType, sValue);
            tDesc.setValue(this.target, sValue, copyOptions.ignoreNullValue, copyOptions.ignoreError, copyOptions.override);
        });
        return (T)this.target;
    }
}

