/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.path;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.DynaBean;
import org.dromara.hutool.core.bean.path.BeanPath;
import org.dromara.hutool.core.bean.path.NodeBeanFactory;
import org.dromara.hutool.core.bean.path.node.EmptyNode;
import org.dromara.hutool.core.bean.path.node.ListNode;
import org.dromara.hutool.core.bean.path.node.NameNode;
import org.dromara.hutool.core.bean.path.node.Node;
import org.dromara.hutool.core.bean.path.node.RangeNode;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.text.StrUtil;

public class DefaultNodeBeanFactory
implements NodeBeanFactory<Object> {
    public static final DefaultNodeBeanFactory INSTANCE = new DefaultNodeBeanFactory();

    @Override
    public Object create(Object parent, BeanPath<Object> beanPath) {
        if (parent instanceof Map || parent instanceof List || ArrayUtil.isArray(parent)) {
            Node node = ((BeanPath)beanPath.next()).getNode();
            if (node instanceof NameNode) {
                return ((NameNode)node).isNumber() ? new ArrayList() : new HashMap();
            }
            return new HashMap();
        }
        Node node = beanPath.getNode();
        if (node instanceof NameNode) {
            String name = ((NameNode)node).getName();
            Field field = FieldUtil.getField(parent.getClass(), name);
            if (null == field) {
                throw new IllegalArgumentException("No field found for name: " + name);
            }
            return ConstructorUtil.newInstanceIfPossible(field.getType());
        }
        throw new UnsupportedOperationException("Unsupported node type: " + node.getClass());
    }

    @Override
    public Object getValue(Object bean, BeanPath<Object> beanPath) {
        Node node = beanPath.getNode();
        if (null == node || node instanceof EmptyNode) {
            return null;
        }
        if (node instanceof ListNode) {
            return DefaultNodeBeanFactory.getValueByListNode(bean, (ListNode)node);
        }
        if (node instanceof NameNode) {
            return DefaultNodeBeanFactory.getValueByNameNode(bean, (NameNode)node);
        }
        if (node instanceof RangeNode) {
            return DefaultNodeBeanFactory.getValueByRangeNode(bean, (RangeNode)node);
        }
        throw new UnsupportedOperationException("Unsupported node type: " + node.getClass());
    }

    @Override
    public Object setValue(Object bean, Object value, BeanPath<Object> beanPath) {
        Node node = beanPath.getNode();
        if (null == node || node instanceof EmptyNode) {
            return bean;
        }
        if (node instanceof NameNode) {
            return DynaBean.of(bean).set(((NameNode)node).getName(), value).getBean();
        }
        throw new UnsupportedOperationException("Unsupported node type: " + node.getClass());
    }

    private static Object getValueByListNode(Object bean, ListNode node) {
        String[] names = node.getUnWrappedNames();
        if (bean instanceof Collection) {
            return CollUtil.getAny((Collection)bean, ConvertUtil.convert(int[].class, (Object)names));
        }
        if (ArrayUtil.isArray(bean)) {
            return ArrayUtil.getAny(bean, ConvertUtil.convert(int[].class, (Object)names));
        }
        Map<String, Object> map = bean instanceof Map ? (Map<String, Object>)bean : BeanUtil.toBeanMap(bean);
        return MapUtil.getAny(map, names);
    }

    private static Object getValueByNameNode(Object bean, NameNode node) {
        String name = node.getName();
        if ("$".equals(name)) {
            return bean;
        }
        Object value = DynaBean.of(bean).get(name);
        if (null == value && StrUtil.lowerFirst(ClassUtil.getClassName(bean, true)).equals(name)) {
            value = bean;
        }
        return value;
    }

    private static Object getValueByRangeNode(Object bean, RangeNode node) {
        if (bean instanceof Collection) {
            return CollUtil.sub((Collection)bean, node.getStart(), node.getEnd(), node.getStep());
        }
        if (ArrayUtil.isArray(bean)) {
            return ArrayUtil.sub(bean, node.getStart(), node.getEnd(), node.getStep());
        }
        throw new UnsupportedOperationException("Can not get range value for: " + bean.getClass());
    }
}

