/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Optional;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.convert.MatcherConverter;
import org.dromara.hutool.core.convert.RegisterConverter;
import org.dromara.hutool.core.convert.SpecialConverter;
import org.dromara.hutool.core.convert.impl.BeanConverter;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class CompositeConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    private RegisterConverter registerConverter;
    private SpecialConverter specialConverter;

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private CompositeConverter() {
    }

    public CompositeConverter register(MatcherConverter converter) {
        this.registerConverter.register(converter);
        return this;
    }

    public CompositeConverter register(Type type, Converter converter) {
        this.registerConverter.register(type, converter);
        return this;
    }

    @Override
    public Object convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    @Override
    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Object result;
        Converter converter;
        if (ObjUtil.isNull(value)) {
            return defaultValue;
        }
        if (TypeUtil.isUnknown(type)) {
            if (null == defaultValue) {
                return (T)value;
            }
            type = defaultValue.getClass();
        }
        if (value instanceof Opt && ObjUtil.isNull(value = ((Opt)value).getOrNull())) {
            return defaultValue;
        }
        if (value instanceof Optional && ObjUtil.isNull(value = ((Optional)value).orElse(null))) {
            return defaultValue;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(type, value, defaultValue);
        }
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        if (null != (converter = this.registerConverter.getConverter(type, value, isCustomFirst))) {
            return converter.convert(type, value, defaultValue);
        }
        Class<?> rawType = TypeUtil.getClass(type);
        if (null == rawType) {
            if (null != defaultValue) {
                rawType = defaultValue.getClass();
            } else {
                throw new ConvertException("Can not get class from type: {}", type);
            }
        }
        if (null != (result = this.specialConverter.convert(type, rawType, value))) {
            return (T)result;
        }
        if (BeanUtil.isWritableBean(rawType)) {
            return (T)BeanConverter.INSTANCE.convert(type, value);
        }
        throw new ConvertException("Can not support from {}: [{}] to [{}]", value.getClass().getName(), value, type.getTypeName());
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }

        static {
            INSTANCE.registerConverter = new RegisterConverter(SingletonHolder.INSTANCE);
            INSTANCE.specialConverter = new SpecialConverter(SingletonHolder.INSTANCE);
        }
    }
}

