/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date;

import java.time.temporal.ChronoField;
import org.dromara.hutool.core.date.Month;
import org.dromara.hutool.core.lang.Assert;

public enum Quarter {
    Q1(1),
    Q2(2),
    Q3(3),
    Q4(4);

    private final int value;

    private Quarter(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static Quarter of(int intValue) {
        switch (intValue) {
            case 1: {
                return Q1;
            }
            case 2: {
                return Q2;
            }
            case 3: {
                return Q3;
            }
            case 4: {
                return Q4;
            }
        }
        return null;
    }

    public static Quarter fromMonth(int monthValue) {
        ChronoField.MONTH_OF_YEAR.checkValidValue(monthValue);
        return Quarter.of(Quarter.computeQuarterValueInternal(monthValue));
    }

    public static Quarter fromMonth(Month month) {
        Assert.notNull(month);
        int monthValue = month.getValue();
        return Quarter.of(Quarter.computeQuarterValueInternal(monthValue));
    }

    public Month firstMonth() {
        return Month.of(this.value * 3 - 3);
    }

    public Month lastMonth() {
        return Month.of(this.value * 3 - 1);
    }

    private static int computeQuarterValueInternal(int monthValue) {
        return (monthValue - 1) / 3 + 1;
    }
}

