/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.convert.CompositeConverter;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class EntryConverter
implements Converter {
    public static final EntryConverter INSTANCE = new EntryConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type keyType = TypeUtil.getTypeArgument(targetType, 0);
        Type valueType = TypeUtil.getTypeArgument(targetType, 1);
        return this.convert(targetType, keyType, valueType, value);
    }

    public Map.Entry<?, ?> convert(Type targetType, Type keyType, Type valueType, Object value) throws ConvertException {
        Map<Object, Object> map = null;
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            map = MapUtil.of(entry.getKey(), entry.getValue());
        } else if (value instanceof Map) {
            map = (HashMap)value;
        } else if (value instanceof CharSequence) {
            CharSequence str = (CharSequence)value;
            map = EntryConverter.strToMap(str);
        } else if (BeanUtil.isWritableBean(value.getClass())) {
            map = BeanUtil.beanToMap(value, new String[0]);
        }
        if (null != map) {
            return EntryConverter.mapToEntry(targetType, keyType, valueType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    private static Map<CharSequence, CharSequence> strToMap(CharSequence str) {
        int index = StrUtil.indexOf(str, c -> c.charValue() == ':' || c.charValue() == '=' || c.charValue() == ',', 0, str.length());
        if (index > -1) {
            return MapUtil.of(str.subSequence(0, index), str.subSequence(index + 1, str.length()));
        }
        return null;
    }

    private static Map.Entry<?, ?> mapToEntry(Type targetType, Type keyType, Type valueType, Map map) {
        Object key = null;
        Object value = null;
        if (1 == map.size()) {
            Map.Entry entry = map.entrySet().iterator().next();
            key = entry.getKey();
            value = entry.getValue();
        } else if (2 == map.size()) {
            key = map.get("key");
            value = map.get("value");
        }
        CompositeConverter convert = CompositeConverter.getInstance();
        return (Map.Entry)ConstructorUtil.newInstance(TypeUtil.getClass(targetType), TypeUtil.isUnknown(keyType) ? key : convert.convert(keyType, key), TypeUtil.isUnknown(valueType) ? value : convert.convert(valueType, value));
    }
}

