/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.func.SerConsumer;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.file.FileWrapper;

public class FileReader
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileReader of(File file, Charset charset) {
        return new FileReader(file, charset);
    }

    public static FileReader of(File file) {
        return new FileReader(file, DEFAULT_CHARSET);
    }

    public FileReader(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public byte[] readBytes() throws IORuntimeException {
        try {
            return Files.readAllBytes(this.file.toPath());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public String readString() throws IORuntimeException {
        return new String(this.readBytes(), this.charset);
    }

    public <T extends Collection<String>> T readLines(T collection) throws IORuntimeException {
        return this.readLines(collection, null);
    }

    public <T extends Collection<String>> T readLines(T collection, Predicate<String> predicate) throws IORuntimeException {
        this.readLines(s -> {
            if (null == predicate || predicate.test((String)s)) {
                collection.add(s);
            }
        });
        return collection;
    }

    public void readLines(SerConsumer<String> lineHandler) throws IORuntimeException {
        BufferedReader reader = null;
        try {
            reader = FileUtil.getReader(this.file, this.charset);
            IoUtil.readLines((Reader)reader, lineHandler);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(reader);
            throw throwable;
        }
        IoUtil.closeQuietly(reader);
    }

    public List<String> readLines() throws IORuntimeException {
        return this.readLines(new ArrayList());
    }

    public <T> T read(SerFunction<BufferedReader, T> readerHandler) throws IORuntimeException {
        T result;
        BufferedReader reader = null;
        try {
            reader = FileUtil.getReader(this.file, this.charset);
            result = readerHandler.applying(reader);
        }
        catch (Exception e) {
            try {
                if (e instanceof IOException) {
                    throw new IORuntimeException(e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new HutoolException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(reader);
        return result;
    }

    public BufferedReader getReader() throws IORuntimeException {
        return IoUtil.toReader(this.getInputStream(), this.charset);
    }

    public BufferedInputStream getInputStream() throws IORuntimeException {
        try {
            return new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public long writeToStream(OutputStream out) throws IORuntimeException {
        return this.writeToStream(out, false);
    }

    /*
     * Loose catch block
     */
    public long writeToStream(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        long l;
        FileInputStream in;
        block10: {
            in = new FileInputStream(this.file);
            l = IoUtil.copy((InputStream)in, out);
            in.close();
            if (!isCloseOut) break block10;
            IoUtil.closeQuietly(out);
        }
        return l;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IORuntimeException(e);
                    }
                }
                catch (Throwable throwable3) {
                    if (isCloseOut) {
                        IoUtil.closeQuietly(out);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private void checkFile() throws IORuntimeException {
        if (!this.file.exists()) {
            throw new IORuntimeException("File not exist: " + this.file);
        }
        if (!this.file.isFile()) {
            throw new IORuntimeException("Not a file:" + this.file);
        }
    }
}

