/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.map.concurrent;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.concurrent.EntryWeigher;
import org.dromara.hutool.core.map.concurrent.Weigher;

public final class Weighers {
    private Weighers() {
        throw new AssertionError();
    }

    public static <K, V> EntryWeigher<K, V> asEntryWeigher(Weigher<? super V> weigher) {
        return weigher == Weighers.singleton() ? Weighers.entrySingleton() : new EntryWeigherView(weigher);
    }

    public static <K, V> EntryWeigher<K, V> entrySingleton() {
        return SingletonEntryWeigher.INSTANCE;
    }

    public static <V> Weigher<V> singleton() {
        return SingletonWeigher.INSTANCE;
    }

    public static Weigher<byte[]> byteArray() {
        return ByteArrayWeigher.INSTANCE;
    }

    public static <E> Weigher<? super Iterable<E>> iterable() {
        return IterableWeigher.INSTANCE;
    }

    public static <E> Weigher<? super Collection<E>> collection() {
        return CollectionWeigher.INSTANCE;
    }

    public static <E> Weigher<? super List<E>> list() {
        return ListWeigher.INSTANCE;
    }

    public static <E> Weigher<? super Set<E>> set() {
        return SetWeigher.INSTANCE;
    }

    public static <K, V> Weigher<? super Map<K, V>> map() {
        return MapWeigher.INSTANCE;
    }

    static final class EntryWeigherView<K, V>
    implements EntryWeigher<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Weigher<? super V> weigher;

        EntryWeigherView(Weigher<? super V> weigher) {
            Assert.notNull(weigher);
            this.weigher = weigher;
        }

        @Override
        public int weightOf(K key, V value) {
            return this.weigher.weightOf(value);
        }
    }

    static enum SingletonEntryWeigher implements EntryWeigher<Object, Object>
    {
        INSTANCE;


        @Override
        public int weightOf(Object key, Object value) {
            return 1;
        }
    }

    static enum SingletonWeigher implements Weigher<Object>
    {
        INSTANCE;


        @Override
        public int weightOf(Object value) {
            return 1;
        }
    }

    static enum ByteArrayWeigher implements Weigher<byte[]>
    {
        INSTANCE;


        @Override
        public int weightOf(byte[] value) {
            return value.length;
        }
    }

    static enum IterableWeigher implements Weigher<Iterable<?>>
    {
        INSTANCE;


        @Override
        public int weightOf(Iterable<?> values) {
            if (values instanceof Collection) {
                return ((Collection)values).size();
            }
            return IterUtil.size(values);
        }
    }

    static enum CollectionWeigher implements Weigher<Collection<?>>
    {
        INSTANCE;


        @Override
        public int weightOf(Collection<?> values) {
            return values.size();
        }
    }

    static enum ListWeigher implements Weigher<List<?>>
    {
        INSTANCE;


        @Override
        public int weightOf(List<?> values) {
            return values.size();
        }
    }

    static enum SetWeigher implements Weigher<Set<?>>
    {
        INSTANCE;


        @Override
        public int weightOf(Set<?> values) {
            return values.size();
        }
    }

    static enum MapWeigher implements Weigher<Map<?, ?>>
    {
        INSTANCE;


        @Override
        public int weightOf(Map<?, ?> values) {
            return values.size();
        }
    }
}

