/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.dromara.hutool.core.annotation.AnnotatedElementUtil;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.method.MethodMatcher;
import org.dromara.hutool.core.text.CharSequenceUtil;
import org.jetbrains.annotations.NotNull;

public class MethodMatcherUtil {
    public static MethodMatcher alwaysMatch() {
        return method -> true;
    }

    public static MethodMatcher of(Predicate<Method> predicate) {
        return predicate::test;
    }

    public static MethodMatcher noneMatch(MethodMatcher ... matchers) {
        return method -> Stream.of(matchers).noneMatch(matcher -> matcher.test(method));
    }

    public static MethodMatcher anyMatch(MethodMatcher ... matchers) {
        return method -> Stream.of(matchers).anyMatch(matcher -> matcher.test(method));
    }

    public static MethodMatcher allMatch(MethodMatcher ... matchers) {
        return method -> Stream.of(matchers).allMatch(matcher -> matcher.test(method));
    }

    public static MethodMatcher isPublic() {
        return MethodMatcherUtil.forModifiers(1);
    }

    public static MethodMatcher isStatic() {
        return MethodMatcherUtil.forModifiers(8);
    }

    public static MethodMatcher isPublicStatic() {
        return MethodMatcherUtil.forModifiers(1, 8);
    }

    public static MethodMatcher forModifiers(int ... modifiers) {
        return method -> {
            int methodModifiers = method.getModifiers();
            return Arrays.stream(modifiers).allMatch(modifier -> (methodModifiers & modifier) != 0);
        };
    }

    public static MethodMatcher hasDeclaredAnnotation(Class<? extends Annotation> annotationType) {
        return method -> method.isAnnotationPresent(annotationType);
    }

    public static MethodMatcher hasAnnotation(Class<? extends Annotation> annotationType) {
        return method -> AnnotatedElementUtil.isAnnotationPresent(method, annotationType);
    }

    public static MethodMatcher hasAnnotationOnDeclaringClass(Class<? extends Annotation> annotationType) {
        return method -> AnnotatedElementUtil.isAnnotationPresent(method.getDeclaringClass(), annotationType);
    }

    public static MethodMatcher hasAnnotationOnMethodOrDeclaringClass(Class<? extends Annotation> annotationType) {
        return method -> AnnotatedElementUtil.isAnnotationPresent(method, annotationType) || AnnotatedElementUtil.isAnnotationPresent(method.getDeclaringClass(), annotationType);
    }

    public static MethodMatcher forGetterMethod(String fieldName, Class<?> fieldType) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(fieldType);
        Predicate<Method> nameMatcher = MethodMatcherUtil.forName(CharSequenceUtil.upperFirstAndAddPre(fieldName, "get"));
        nameMatcher = nameMatcher.or((Predicate)MethodMatcherUtil.forName(fieldName));
        if (Objects.equals(Boolean.TYPE, fieldType) || Objects.equals(Boolean.class, fieldType)) {
            nameMatcher = nameMatcher.or((Predicate)MethodMatcherUtil.forName(CharSequenceUtil.upperFirstAndAddPre(fieldName, "is")));
        }
        return MethodMatcherUtil.allMatch(new MethodMatcher[]{nameMatcher, MethodMatcherUtil.forReturnType(fieldType), MethodMatcherUtil.forNoneParameter()});
    }

    public static MethodMatcher forGetterMethod(Field field) {
        Objects.requireNonNull(field);
        return MethodMatcherUtil.forGetterMethod(field.getName(), field.getType());
    }

    public static MethodMatcher forSetterMethod(String fieldName, Class<?> fieldType) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(fieldType);
        Predicate nameMatcher = MethodMatcherUtil.forName(CharSequenceUtil.upperFirstAndAddPre(fieldName, "set")).or((Predicate)MethodMatcherUtil.forName(fieldName));
        return MethodMatcherUtil.allMatch(new MethodMatcher[]{nameMatcher, MethodMatcherUtil.forParameterTypes(fieldType)});
    }

    public static MethodMatcher forSetterMethod(Field field) {
        Objects.requireNonNull(field);
        return MethodMatcherUtil.forSetterMethod(field.getName(), field.getType());
    }

    public static MethodMatcher forNameAndParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forName(methodName), MethodMatcherUtil.forParameterTypes(parameterTypes));
    }

    public static MethodMatcher forNameAndStrictParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forName(methodName), MethodMatcherUtil.forStrictParameterTypes(parameterTypes));
    }

    public static MethodMatcher forNameIgnoreCaseAndParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forNameIgnoreCase(methodName), MethodMatcherUtil.forParameterTypes(parameterTypes));
    }

    public static MethodMatcher forNameIgnoreCaseAndStrictParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forNameIgnoreCase(methodName), MethodMatcherUtil.forStrictParameterTypes(parameterTypes));
    }

    public static MethodMatcher forMethodSignature(Method method) {
        Objects.requireNonNull(method);
        return MethodMatcherUtil.forMethodSignature(method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public static MethodMatcher forMethodSignature(String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        MethodMatcher resultMatcher = Objects.isNull(returnType) ? MethodMatcherUtil.forNoneReturnType() : MethodMatcherUtil.forReturnType(returnType);
        MethodMatcher parameterMatcher = Objects.isNull(parameterTypes) ? MethodMatcherUtil.forNoneParameter() : MethodMatcherUtil.forParameterTypes(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forName(methodName), resultMatcher, parameterMatcher);
    }

    public static MethodMatcher forStrictMethodSignature(String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        MethodMatcher resultMatcher = Objects.isNull(returnType) ? MethodMatcherUtil.forNoneReturnType() : MethodMatcherUtil.forReturnType(returnType);
        MethodMatcher parameterMatcher = Objects.isNull(parameterTypes) ? MethodMatcherUtil.forNoneParameter() : MethodMatcherUtil.forStrictParameterTypes(parameterTypes);
        return MethodMatcherUtil.allMatch(MethodMatcherUtil.forName(methodName), resultMatcher, parameterMatcher);
    }

    public static MethodMatcher forStrictMethodSignature(Method method) {
        Objects.requireNonNull(method);
        return MethodMatcherUtil.forMethodSignature(method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public static MethodMatcher forName(String methodName) {
        return method -> Objects.equals(method.getName(), methodName);
    }

    public static MethodMatcher forNameIgnoreCase(String methodName) {
        return method -> CharSequenceUtil.endWithIgnoreCase(method.getName(), methodName);
    }

    public static MethodMatcher forNoneReturnType() {
        return method -> Objects.equals(method.getReturnType(), Void.TYPE);
    }

    public static MethodMatcher forReturnType(Class<?> returnType) {
        return method -> ClassUtil.isAssignable(returnType, method.getReturnType());
    }

    public static MethodMatcher forStrictReturnType(Class<?> returnType) {
        return method -> Objects.equals(method.getReturnType(), returnType);
    }

    public static MethodMatcher forNoneParameter() {
        return method -> method.getParameterCount() == 0;
    }

    public static MethodMatcher forParameterCount(int count) {
        return method -> method.getParameterCount() == count;
    }

    public static MethodMatcher forParameterTypes(Class<?> ... parameterTypes) {
        Objects.requireNonNull(parameterTypes);
        return method -> ClassUtil.isAllAssignableFrom(parameterTypes, method.getParameterTypes());
    }

    public static MethodMatcher forMostSpecificParameterTypes(Class<?> ... parameterTypes) {
        return MethodMatcherUtil.mostSpecificStrictParameterTypesMatcher(parameterTypes, ClassUtil::isAssignable);
    }

    public static MethodMatcher forMostSpecificStrictParameterTypes(Class<?> ... parameterTypes) {
        return MethodMatcherUtil.mostSpecificStrictParameterTypesMatcher(parameterTypes, Objects::equals);
    }

    public static MethodMatcher forStrictParameterTypes(Class<?> ... parameterTypes) {
        Objects.requireNonNull(parameterTypes);
        return method -> ArrayUtil.equals(method.getParameterTypes(), parameterTypes);
    }

    @NotNull
    private static MethodMatcher mostSpecificStrictParameterTypesMatcher(Class<?>[] parameterTypes, BiPredicate<Class<?>, Class<?>> typeMatcher) {
        Objects.requireNonNull(parameterTypes);
        if (parameterTypes.length == 0) {
            MethodMatcher methodMatcher = MethodMatcherUtil.forNoneParameter();
            if (methodMatcher == null) {
                MethodMatcherUtil.$$$reportNull$$$0(0);
            }
            return methodMatcher;
        }
        MethodMatcher methodMatcher = method -> {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            if (parameterTypes.length > methodParameterTypes.length) {
                return false;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class parameterType = parameterTypes[i];
                if (Objects.isNull(parameterType) || !typeMatcher.negate().test(parameterType, methodParameterTypes[i])) continue;
                return false;
            }
            return true;
        };
        if (methodMatcher == null) {
            MethodMatcherUtil.$$$reportNull$$$0(1);
        }
        return methodMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/dromara/hutool/core/reflect/method/MethodMatcherUtil", "mostSpecificStrictParameterTypesMatcher"));
    }
}

