/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.dfa;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.dfa.FoundWord;
import org.dromara.hutool.core.text.dfa.SensitiveProcessor;
import org.dromara.hutool.core.text.dfa.WordTree;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.thread.ThreadUtil;

public final class SensitiveUtil {
    public static final String DEFAULT_SEPARATOR = ",";
    private static final WordTree sensitiveTree = new WordTree();

    public static boolean isInited() {
        return !sensitiveTree.isEmpty();
    }

    public static void init(Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            ThreadUtil.execAsync(() -> {
                SensitiveUtil.init(sensitiveWords);
                return true;
            });
        } else {
            SensitiveUtil.init(sensitiveWords);
        }
    }

    public static void init(Collection<String> sensitiveWords) {
        sensitiveTree.clear();
        sensitiveTree.addWords(sensitiveWords);
    }

    public static void init(String sensitiveWords, String separator, boolean isAsync) {
        if (StrUtil.isNotBlank(sensitiveWords)) {
            SensitiveUtil.init(SplitUtil.split(sensitiveWords, separator), isAsync);
        }
    }

    public static void init(String sensitiveWords, boolean isAsync) {
        SensitiveUtil.init(sensitiveWords, DEFAULT_SEPARATOR, isAsync);
    }

    public static void setCharFilter(Predicate<Character> charFilter) {
        if (charFilter != null) {
            sensitiveTree.setCharFilter(charFilter);
        }
    }

    public static boolean containsSensitive(String text) {
        return sensitiveTree.isMatch(text);
    }

    public static FoundWord getFoundFirstSensitive(String text) {
        return sensitiveTree.matchWord(text);
    }

    public static List<FoundWord> getFoundAllSensitive(String text) {
        return sensitiveTree.matchAllWords(text);
    }

    public static List<FoundWord> getFoundAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAllWords(text, -1, isDensityMatch, isGreedMatch);
    }

    public static String sensitiveFilter(String text) {
        return SensitiveUtil.sensitiveFilter(text, true, null);
    }

    public static String sensitiveFilter(String text, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        if (StrUtil.isEmpty(text)) {
            return text;
        }
        List<FoundWord> foundWordList = SensitiveUtil.getFoundAllSensitive(text, true, isGreedMatch);
        if (CollUtil.isEmpty(foundWordList)) {
            return text;
        }
        sensitiveProcessor = sensitiveProcessor == null ? new SensitiveProcessor(){} : sensitiveProcessor;
        HashMap foundWordMap = new HashMap(foundWordList.size(), 1.0f);
        foundWordList.forEach(foundWord -> foundWordMap.put((Integer)foundWord.getBeginIndex(), foundWord));
        int length = text.length();
        StringBuilder textStringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            FoundWord fw = (FoundWord)foundWordMap.get(i);
            if (fw != null) {
                textStringBuilder.append(sensitiveProcessor.process(fw));
                i = (Integer)fw.getEndIndex();
                continue;
            }
            textStringBuilder.append(text.charAt(i));
        }
        return textStringBuilder.toString();
    }
}

