/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.lang.Console;
import org.dromara.hutool.core.text.StrUtil;

public class ConsoleTable {
    private static final char ROW_LINE = '\uff0d';
    private static final char COLUMN_LINE = '|';
    private static final char CORNER = '+';
    private static final char SPACE = '\u3000';
    private static final char LF = '\n';
    private boolean isSBCMode = true;
    private final List<List<String>> headerList = new ArrayList<List<String>>();
    private final List<List<String>> bodyList = new ArrayList<List<String>>();
    private List<Integer> columnCharNumber;

    public static ConsoleTable of() {
        return new ConsoleTable();
    }

    public ConsoleTable setSBCMode(boolean isSBCMode) {
        this.isSBCMode = isSBCMode;
        return this;
    }

    public ConsoleTable addHeader(String ... titles) {
        if (this.columnCharNumber == null) {
            this.columnCharNumber = new ArrayList<Integer>(Collections.nCopies(titles.length, 0));
        }
        ArrayList<String> l = new ArrayList<String>();
        this.fillColumns(l, titles);
        this.headerList.add(l);
        return this;
    }

    public ConsoleTable addBody(String ... values) {
        ArrayList<String> l = new ArrayList<String>();
        this.bodyList.add(l);
        this.fillColumns(l, values);
        return this;
    }

    private void fillColumns(List<String> l, String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            if (this.isSBCMode) {
                column = Convert.toSBC(column);
            }
            l.add(column);
            int width = column.length();
            if (width <= this.columnCharNumber.get(i)) continue;
            this.columnCharNumber.set(i, width);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.fillBorder(sb);
        this.fillRows(sb, this.headerList);
        this.fillBorder(sb);
        this.fillRows(sb, this.bodyList);
        this.fillBorder(sb);
        return sb.toString();
    }

    private void fillRows(StringBuilder sb, List<List<String>> list) {
        for (List<String> row : list) {
            sb.append('|');
            this.fillRow(sb, row);
            sb.append('\n');
        }
    }

    private void fillRow(StringBuilder sb, List<String> row) {
        int size = row.size();
        for (int i = 0; i < size; ++i) {
            String value = row.get(i);
            sb.append('\u3000');
            sb.append(value);
            int length = value.length();
            int sbcCount = this.sbcCount(value);
            if (sbcCount % 2 == 1) {
                sb.append(' ');
            }
            sb.append('\u3000');
            int maxLength = this.columnCharNumber.get(i);
            for (int j = 0; j < maxLength - length + sbcCount / 2; ++j) {
                sb.append('\u3000');
            }
            sb.append('|');
        }
    }

    private void fillBorder(StringBuilder sb) {
        sb.append('+');
        for (Integer width : this.columnCharNumber) {
            sb.append(StrUtil.repeat('\uff0d', width + 2));
            sb.append('+');
        }
        sb.append('\n');
    }

    public void print() {
        Console.print(this.toString());
    }

    private int sbcCount(String value) {
        int count = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) >= '\u007f') continue;
            ++count;
        }
        return count;
    }
}

