/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.map;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.map.CamelCaseLinkedMap;
import org.dromara.hutool.core.map.CamelCaseMap;
import org.dromara.hutool.core.map.MapBuilder;
import org.dromara.hutool.core.map.MapGetUtil;
import org.dromara.hutool.core.map.MapJoiner;
import org.dromara.hutool.core.map.MapProxy;
import org.dromara.hutool.core.map.MapWrapper;
import org.dromara.hutool.core.map.SafeConcurrentHashMap;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class MapUtil
extends MapGetUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtil.isEmpty(map);
    }

    public static <K, V> Map<K, V> emptyIfNull(Map<K, V> set) {
        return null == set ? Collections.emptyMap() : set;
    }

    public static <T extends Map<K, V>, K, V> T defaultIfEmpty(T map, T defaultMap) {
        return MapUtil.isEmpty(map) ? defaultMap : map;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isLinked ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtil.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isLinked) {
        return MapUtil.newHashMap(16, isLinked);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (MapUtil.isNotEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static <K, V> Map<K, V> newIdentityMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> ConcurrentHashMap<K, V> newSafeConcurrentHashMap() {
        return new SafeConcurrentHashMap(16);
    }

    public static <K, V> ConcurrentHashMap<K, V> newSafeConcurrentHashMap(int size) {
        int initCapacity = size <= 0 ? 16 : size;
        return new SafeConcurrentHashMap(initCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newSafeConcurrentHashMap(Map<K, V> map) {
        if (MapUtil.isEmpty(map)) {
            return new ConcurrentHashMap(16);
        }
        return new SafeConcurrentHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        return MapUtil.createMap(mapType, HashMap::new);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType, Supplier<Map<K, V>> defaultMap) {
        Map result = null;
        if (null != mapType && !mapType.isAssignableFrom(AbstractMap.class)) {
            result = (Map)ConstructorUtil.newInstanceIfPossible(mapType);
        }
        if (null == result) {
            result = defaultMap.get();
        }
        if (!result.isEmpty()) {
            result.clear();
        }
        return result;
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return MapUtil.of(key, value, false);
    }

    public static <K, V> HashMap<K, V> of(K key, V value, boolean isOrder) {
        HashMap<K, V> map = MapUtil.newHashMap(isOrder);
        map.put(key, value);
        return map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> ofEntries(Map.Entry<K, V> ... entries) {
        return MapUtil.ofEntries(new ArrayIter<Map.Entry<K, V>>((E[])entries));
    }

    public static <K, V> HashMap<K, V> ofEntries(Iterable<Map.Entry<K, V>> entryIter) {
        return MapUtil.ofEntries(IterUtil.getIter(entryIter));
    }

    public static <K, V> HashMap<K, V> ofEntries(Iterator<Map.Entry<K, V>> entryIter) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (IterUtil.isNotEmpty(entryIter)) {
            while (entryIter.hasNext()) {
                Map.Entry<K, V> entry = entryIter.next();
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static HashMap<Object, Object> of(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object value;
            Object key;
            Iterator iter;
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length <= 1) continue;
                map.put(entry[0], entry[1]);
                continue;
            }
            if (object instanceof Iterable) {
                iter = ((Iterable)object).iterator();
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            if (object instanceof Iterator) {
                iter = (Iterator)object;
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(StrUtil.format("Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i, object));
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        HashMap<Object, List> resultMap = new HashMap<Object, List>();
        if (CollUtil.isEmpty(mapList)) {
            return resultMap;
        }
        for (Map<K, V> map : mapList) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                resultMap.computeIfAbsent(entry.getKey(), k -> new ArrayList()).add(entry.getValue());
            }
        }
        return resultMap;
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        if (MapUtil.isEmpty(listMap)) {
            return ListUtil.zero();
        }
        ArrayList<Map<K, V>> resultList = new ArrayList<Map<K, V>>();
        for (Map.Entry<K, Iterable<V>> entry : listMap.entrySet()) {
            Iterator<V> iterator = IterUtil.getIter(entry.getValue());
            if (IterUtil.isEmpty(iterator)) continue;
            K key = entry.getKey();
            for (Map map : resultList) {
                if (!iterator.hasNext()) break;
                map.put(key, iterator.next());
            }
            while (iterator.hasNext()) {
                resultList.add(MapUtil.of(key, iterator.next()));
            }
        }
        return resultList;
    }

    public static <K, V> Map<K, V> toCamelCaseMap(Map<K, V> map) {
        return map instanceof LinkedHashMap ? new CamelCaseLinkedMap<K, V>(map) : new CamelCaseMap<K, V>(map);
    }

    public static Object[][] toObjectArray(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Object[][] result = new Object[map.size()][2];
        if (map.isEmpty()) {
            return result;
        }
        int index = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result[index][0] = entry.getKey();
            result[index][1] = entry.getValue();
            ++index;
        }
        return result;
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        return MapUtil.join(map, separator, keyValueSeparator, false, otherParams);
    }

    public static String sortJoin(Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return MapUtil.join(MapUtil.sort(params), separator, keyValueSeparator, isIgnoreNull, otherParams);
    }

    public static <K, V> String joinIgnoreNull(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        return MapUtil.join(map, separator, keyValueSeparator, true, otherParams);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        return MapUtil.join(map, separator, keyValueSeparator, (Map.Entry<K, V> entry) -> !isIgnoreNull || entry.getKey() != null && entry.getValue() != null, otherParams);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, Predicate<Map.Entry<K, V>> predicate, String ... otherParams) {
        return MapJoiner.of(separator, keyValueSeparator).append(map, predicate).append(otherParams).toString();
    }

    public static <K, V> Map<K, V> edit(Map<K, V> map, UnaryOperator<Map.Entry<K, V>> editor) {
        if (null == map || null == editor) {
            return map;
        }
        Map map2 = MapUtil.createMap(map.getClass(), () -> new HashMap(map.size(), 1.0f));
        if (MapUtil.isEmpty(map)) {
            return map2;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry modified = (Map.Entry)editor.apply(entry);
            if (null == modified) continue;
            map2.put(modified.getKey(), modified.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        if (null == map || null == predicate) {
            return map;
        }
        return MapUtil.edit(map, t -> predicate.test((Map.Entry)t) ? t : null);
    }

    public static <K, V, R> Map<K, R> map(Map<K, V> map, BiFunction<K, V, R> biFunction) {
        if (null == map || null == biFunction) {
            return MapUtil.newHashMap();
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, m -> biFunction.apply(m.getKey(), m.getValue())));
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, K ... keys) {
        if (null == map || null == keys) {
            return map;
        }
        Map<K, V> map2 = MapUtil.createMap(map.getClass(), () -> new HashMap(map.size(), 1.0f));
        if (MapUtil.isEmpty(map)) {
            return map2;
        }
        for (K key : keys) {
            if (!map.containsKey(key)) continue;
            map2.put(key, map.get(key));
        }
        return map2;
    }

    public static <T> Map<T, T> reverse(Map<T, T> map) {
        return MapUtil.edit(map, t -> new Map.Entry<T, T>((Map.Entry)t){
            final /* synthetic */ Map.Entry val$t;
            {
                this.val$t = entry;
            }

            @Override
            public T getKey() {
                return this.val$t.getValue();
            }

            @Override
            public T getValue() {
                return this.val$t.getKey();
            }

            @Override
            public T setValue(T value) {
                throw new UnsupportedOperationException("Unsupported setValue method !");
            }
        });
    }

    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        Map result = MapUtil.createMap(map.getClass());
        map.forEach((key, value) -> result.put(value, key));
        return result;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map) {
        return MapUtil.sort(map, null);
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        if (null == map) {
            return null;
        }
        if (map instanceof TreeMap) {
            TreeMap result = (TreeMap)map;
            if (null == comparator || comparator.equals(result.comparator())) {
                return result;
            }
        }
        return MapUtil.newTreeMap(map, comparator);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, boolean isDesc) {
        LinkedHashMap result = new LinkedHashMap();
        Comparator entryComparator = Map.Entry.comparingByValue();
        if (isDesc) {
            entryComparator = entryComparator.reversed();
        }
        map.entrySet().stream().sorted(entryComparator).forEachOrdered(e -> {
            Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
        });
        return result;
    }

    public static MapProxy createProxy(Map<?, ?> map) {
        return MapProxy.of(map);
    }

    public static <K, V> MapWrapper<K, V> wrap(Map<K, V> map) {
        return new MapWrapper<K, V>(map);
    }

    public static <K, V> Map<K, V> view(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> MapBuilder<K, V> builder() {
        return MapUtil.builder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static <K, V> MapBuilder<K, V> builder(K k, V v) {
        return MapUtil.builder(new HashMap()).put(k, v);
    }

    public static <K, V> Map<K, V> getAny(Map<K, V> map, K ... keys) {
        return MapUtil.filter(map, entry -> ArrayUtil.contains(keys, entry.getKey()));
    }

    public static <K, V, T extends Map<K, V>> T removeAny(T map, K ... keys) {
        for (K key : keys) {
            map.remove(key);
        }
        return map;
    }

    public static <K, V> Map<K, V> renameKey(Map<K, V> map, K oldKey, K newKey) {
        if (MapUtil.isNotEmpty(map) && map.containsKey(oldKey)) {
            if (map.containsKey(newKey)) {
                throw new IllegalArgumentException(StrUtil.format("The key '{}' exist !", newKey));
            }
            map.put(newKey, map.remove(oldKey));
        }
        return map;
    }

    public static <K, V> Map<K, V> removeNullValue(Map<K, V> map) {
        if (MapUtil.isEmpty(map)) {
            return map;
        }
        map.entrySet().removeIf(entry -> null == entry.getValue());
        return map;
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> zero() {
        return new HashMap(0, 1.0f);
    }

    public static <K, V, T extends Map<K, V>> T empty(Class<?> mapClass) {
        if (null == mapClass) {
            return (T)Collections.emptyMap();
        }
        if (NavigableMap.class == mapClass) {
            return (T)Collections.emptyNavigableMap();
        }
        if (SortedMap.class == mapClass) {
            return (T)Collections.emptySortedMap();
        }
        if (Map.class == mapClass) {
            return (T)Collections.emptyMap();
        }
        throw new IllegalArgumentException(StrUtil.format("[{}] is not support to get empty!", mapClass));
    }

    public static void clear(Map<?, ?> ... maps) {
        for (Map<?, ?> map : maps) {
            if (!MapUtil.isNotEmpty(map)) continue;
            map.clear();
        }
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, K ... keys) {
        return MapUtil.valuesOfKeys(map, new ArrayIter<K>(keys));
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterable<K> keys) {
        return MapUtil.valuesOfKeys(map, keys.iterator());
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterator<K> keys) {
        ArrayList<V> values = new ArrayList<V>();
        while (keys.hasNext()) {
            values.add(map.get(keys.next()));
        }
        return values;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return MapUtil.entry(key, value, true);
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value, boolean isImmutable) {
        return isImmutable ? new AbstractMap.SimpleImmutableEntry<K, V>(key, value) : new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterable<V> iterable, Function<V, K> keyMapper) {
        return MapUtil.putAll(resultMap, iterable, keyMapper, Function.identity());
    }

    public static <T, K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return MapUtil.putAll(resultMap, IterUtil.getIter(iterable), keyMapper, valueMapper);
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterator<V> iterator, Function<V, K> keyMapper) {
        return MapUtil.putAll(resultMap, iterator, keyMapper, Function.identity());
    }

    public static <T, K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterator<T> iterator, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapUtil.newHashMap();
        }
        if (ObjUtil.isNull(iterator)) {
            return resultMap;
        }
        while (iterator.hasNext()) {
            T value = iterator.next();
            resultMap.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <K, V> Map<K, List<V>> grouping(Iterable<Map.Entry<K, V>> entries) {
        if (CollUtil.isEmpty(entries)) {
            return MapUtil.zero();
        }
        HashMap<Object, List> map = new HashMap<Object, List>();
        for (Map.Entry<K, V> pair : entries) {
            List values = map.computeIfAbsent(pair.getKey(), k -> new ArrayList());
            values.add(pair.getValue());
        }
        return map;
    }

    public static <K, V> V computeIfAbsentForJdk8(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        V res;
        V value = map.get(key);
        if (null == value && null != (res = map.putIfAbsent(key, value = mappingFunction.apply(key)))) {
            return res;
        }
        return value;
    }
}

