/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.dfa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.text.dfa.FoundWord;

public class NFA {
    private final Node root = new Node();
    private volatile boolean needBuildAc = true;
    private final Object buildAcLock = new Object();
    private final Object insertTreeLock = new Object();

    public NFA() {
    }

    public NFA(String ... words) {
        this();
        this.insert(words);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String word) {
        Object object = this.insertTreeLock;
        synchronized (object) {
            this.needBuildAc = true;
            Node p = this.root;
            for (char curr : word.toCharArray()) {
                if (p.next.get(curr) == null) {
                    p.next.put(Integer.valueOf(curr), new Node());
                }
                p = p.next.get(curr);
            }
            p.flag = true;
            p.str = word;
        }
    }

    public void insert(String ... words) {
        for (String word : words) {
            this.insert(word);
        }
    }

    private void buildAc() {
        LinkedList<Node> queue = new LinkedList<Node>();
        Node p = this.root;
        for (Integer key : p.next.keySet()) {
            p.next.get((Object)key).fail = this.root;
            queue.offer(p.next.get(key));
        }
        while (!queue.isEmpty()) {
            Node curr = (Node)queue.poll();
            for (Integer key : curr.next.keySet()) {
                Node fail = curr.fail;
                while (fail != null && fail.next.get(key) == null) {
                    fail = fail.fail;
                }
                fail = fail != null ? fail.next.get(key) : this.root;
                curr.next.get((Object)key).fail = fail;
                queue.offer(curr.next.get(key));
            }
        }
        this.needBuildAc = false;
    }

    public List<FoundWord> find(String text) {
        return this.find(text, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FoundWord> find(String text, boolean isDensityMatch) {
        if (this.needBuildAc) {
            Object object = this.buildAcLock;
            synchronized (object) {
                if (this.needBuildAc) {
                    this.buildAc();
                }
            }
        }
        ArrayList<FoundWord> ans = new ArrayList<FoundWord>();
        Node p = this.root;
        Node k = null;
        int len = text.length();
        block3: for (int i = 0; i < len; ++i) {
            char ind = text.charAt(i);
            while (p != null && p.next.get(ind) == null) {
                p = p.fail;
            }
            p = p == null ? this.root : p.next.get(ind);
            k = p;
            while (k != null) {
                if (k.flag) {
                    ans.add(new FoundWord(k.str, k.str, i - k.str.length() + 1, i));
                    if (!isDensityMatch) {
                        p = this.root;
                        continue block3;
                    }
                }
                k = k.fail;
            }
        }
        return ans;
    }

    private static class Node {
        boolean flag = false;
        Node fail;
        String str;
        Map<Integer, Node> next = new HashMap<Integer, Node>();
    }
}

