/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dromara.hutool.core.date.DateUnit;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.func.SerConsumer;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileMode;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.file.LineReadWatcher;
import org.dromara.hutool.core.io.watch.SimpleWatcher;
import org.dromara.hutool.core.io.watch.WatchKind;
import org.dromara.hutool.core.io.watch.WatchMonitor;
import org.dromara.hutool.core.lang.Console;
import org.dromara.hutool.core.util.CharsetUtil;

public class Tailer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final SerConsumer<String> CONSOLE_HANDLER = new ConsoleLineHandler();
    private final Charset charset;
    private final SerConsumer<String> lineHandler;
    private final int initReadLine;
    private final long period;
    private final String filePath;
    private final RandomAccessFile randomAccessFile;
    private final ScheduledExecutorService executorService;
    private WatchMonitor fileDeleteWatchMonitor;
    private boolean stopOnDelete;

    public Tailer(File file, SerConsumer<String> lineHandler) {
        this(file, lineHandler, 0);
    }

    public Tailer(File file, SerConsumer<String> lineHandler, int initReadLine) {
        this(file, CharsetUtil.UTF_8, lineHandler, initReadLine, DateUnit.SECOND.getMillis());
    }

    public Tailer(File file, Charset charset, SerConsumer<String> lineHandler) {
        this(file, charset, lineHandler, 0, DateUnit.SECOND.getMillis());
    }

    public Tailer(File file, Charset charset, SerConsumer<String> lineHandler, int initReadLine, long period) {
        Tailer.checkFile(file);
        this.filePath = file.getAbsolutePath();
        this.charset = charset;
        this.lineHandler = lineHandler;
        this.period = period;
        this.initReadLine = initReadLine;
        this.randomAccessFile = FileUtil.createRandomAccessFile(file, FileMode.r);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void setStopOnDelete(boolean stopOnDelete) {
        this.stopOnDelete = stopOnDelete;
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean async) {
        try {
            this.readTail();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        LineReadWatcher lineReadWatcher = new LineReadWatcher(this.randomAccessFile, this.charset, this.lineHandler);
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(lineReadWatcher, 0L, this.period, TimeUnit.MILLISECONDS);
        if (this.stopOnDelete) {
            this.fileDeleteWatchMonitor = WatchMonitor.of(this.filePath, WatchKind.DELETE.getValue());
            this.fileDeleteWatchMonitor.setWatcher(new SimpleWatcher(){

                @Override
                public void onDelete(WatchEvent<?> event, Path currentPath) {
                    super.onDelete(event, currentPath);
                    Tailer.this.stop();
                    throw new IORuntimeException("{} has been deleted", Tailer.this.filePath);
                }
            });
            this.fileDeleteWatchMonitor.start();
        }
        if (!async) {
            try {
                scheduledFuture.get();
            }
            catch (ExecutionException e) {
                throw new HutoolException(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stop() {
        try {
            this.executorService.shutdown();
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(this.randomAccessFile);
            IoUtil.closeQuietly(this.fileDeleteWatchMonitor);
            throw throwable;
        }
        IoUtil.closeQuietly(this.randomAccessFile);
        IoUtil.closeQuietly(this.fileDeleteWatchMonitor);
    }

    private void readTail() throws IOException {
        long len = this.randomAccessFile.length();
        if (this.initReadLine > 0) {
            Stack<String> stack = new Stack<String>();
            long start = this.randomAccessFile.getFilePointer();
            long nextEnd = len - 1L < 0L ? 0L : len - 1L;
            this.randomAccessFile.seek(nextEnd);
            int currentLine = 0;
            while (nextEnd > start && currentLine <= this.initReadLine) {
                String line;
                int c = this.randomAccessFile.read();
                if (c == 10 || c == 13) {
                    line = FileUtil.readLine(this.randomAccessFile, this.charset);
                    if (null != line) {
                        stack.push(line);
                    }
                    ++currentLine;
                    --nextEnd;
                }
                this.randomAccessFile.seek(--nextEnd);
                if (nextEnd != 0L) continue;
                line = FileUtil.readLine(this.randomAccessFile, this.charset);
                if (null == line) break;
                stack.push(line);
                break;
            }
            while (!stack.isEmpty()) {
                this.lineHandler.accept((String)stack.pop());
            }
        }
        try {
            this.randomAccessFile.seek(len);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static void checkFile(File file) {
        if (!file.exists()) {
            throw new HutoolException("File [{}] not exist !", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new HutoolException("Path [{}] is not a file !", file.getAbsolutePath());
        }
    }

    public static class ConsoleLineHandler
    implements SerConsumer<String> {
        private static final long serialVersionUID = 1L;

        @Override
        public void accepting(String line) {
            Console.log(line);
        }
    }
}

