/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.file.PathUtil;
import org.dromara.hutool.core.io.file.visitor.MoveVisitor;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class PathMover {
    private final Path src;
    private final Path target;
    private final CopyOption[] options;

    public static PathMover of(Path src, Path target, boolean isOverride) {
        CopyOption[] copyOptionArray;
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return PathMover.of(src, target, copyOptionArray);
    }

    public static PathMover of(Path src, Path target, CopyOption[] options) {
        return new PathMover(src, target, options);
    }

    public PathMover(Path src, Path target, CopyOption[] options) {
        Assert.notNull(target, "Src path must be not null !", new Object[0]);
        if (!PathUtil.exists(src, false)) {
            throw new IllegalArgumentException("Src path is not exist!");
        }
        this.src = src;
        this.target = Assert.notNull(target, "Target path must be not null !", new Object[0]);
        this.options = ObjUtil.defaultIfNull(options, new CopyOption[0]);
    }

    public Path move() throws IllegalArgumentException {
        Path src = this.src;
        Path target = this.target;
        CopyOption[] options = this.options;
        if (PathUtil.isSub(src, target)) {
            if (Files.exists(target, new LinkOption[0]) && PathUtil.equals(src, target)) {
                return target;
            }
            throw new IllegalArgumentException(StrUtil.format("Target [{}] is sub path of src [{}]!", target, src));
        }
        if (PathUtil.isDirectory(target)) {
            target = target.resolve(src.getFileName());
        }
        PathUtil.mkParentDirs(target);
        try {
            return Files.move(src, target, options);
        }
        catch (IOException e) {
            if (e instanceof FileAlreadyExistsException) {
                throw new IORuntimeException(e);
            }
            PathMover.walkMove(src, target, options);
            PathUtil.del(src);
            return target;
        }
    }

    public Path moveContent() {
        Path src = this.src;
        if (PathUtil.isExistsAndNotDirectory(this.target, false)) {
            return this.move();
        }
        Path target = this.target;
        if (PathUtil.isExistsAndNotDirectory(target, false)) {
            throw new IllegalArgumentException("Can not move dir content to a file");
        }
        if (PathUtil.equals(src, target)) {
            return target;
        }
        CopyOption[] options = this.options;
        PathUtil.mkParentDirs(target);
        PathMover.walkMove(src, target, options);
        return target;
    }

    private static void walkMove(Path src, Path target, CopyOption ... options) {
        try {
            Files.walkFileTree(src, new MoveVisitor(src, target, options));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

