/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.iter.EnumerationIter;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.net.url.URLDecoder;
import org.dromara.hutool.core.net.url.URLUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.SystemUtil;

public class ClassScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String packageNameWithDot;
    private final String packageDirName;
    private final String packagePath;
    private final Predicate<Class<?>> classPredicate;
    private final Charset charset;
    private ClassLoader classLoader;
    private boolean initialize;
    private final Set<Class<?>> classes = new HashSet();
    private boolean ignoreLoadError = false;
    private final Set<String> classesOfLoadError = new HashSet<String>();

    public static Set<Class<?>> scanAllPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanAllPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanAllPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanAllPackage(packageName, clazz -> superClass.isAssignableFrom((Class<?>)clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanPackage(packageName, clazz -> superClass.isAssignableFrom((Class<?>)clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanAllPackage() {
        return ClassScanner.scanAllPackage("", null);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanAllPackage(String packageName, Predicate<Class<?>> classFilter) {
        return new ClassScanner(packageName, classFilter).scan(true);
    }

    public static Set<Class<?>> scanPackage(String packageName, Predicate<Class<?>> classFilter) {
        return new ClassScanner(packageName, classFilter).scan();
    }

    public ClassScanner() {
        this(null);
    }

    public ClassScanner(String packageName) {
        this(packageName, null);
    }

    public ClassScanner(String packageName, Predicate<Class<?>> classPredicate) {
        this(packageName, classPredicate, CharsetUtil.UTF_8);
    }

    public ClassScanner(String packageName, Predicate<Class<?>> classPredicate, Charset charset) {
        this.packageName = packageName = StrUtil.emptyIfNull(packageName);
        this.packageNameWithDot = StrUtil.addSuffixIfNot(packageName, ".");
        this.packageDirName = packageName.replace('.', File.separatorChar);
        this.packagePath = packageName.replace('.', '/');
        this.classPredicate = classPredicate;
        this.charset = charset;
    }

    public Set<Class<?>> scan() {
        return this.scan(false);
    }

    public Set<Class<?>> scan(boolean forceScanJavaClassPaths) {
        this.classes.clear();
        this.classesOfLoadError.clear();
        for (URL url : ResourceUtil.getResourceUrlIter(this.packagePath, this.classLoader)) {
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(URLDecoder.decode(url.getFile(), this.charset)), null);
                    break;
                }
                case "jar": {
                    this.scanJar(URLUtil.getJarFile(url));
                }
            }
        }
        if (forceScanJavaClassPaths || CollUtil.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    public Set<String> getClassesOfLoadError() {
        return Collections.unmodifiableSet(this.classesOfLoadError);
    }

    public void setIgnoreLoadError(boolean ignoreLoadError) {
        this.ignoreLoadError = ignoreLoadError;
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void scanJavaClassPaths() {
        String[] javaClassPaths;
        for (String classPath : javaClassPaths = SystemUtil.getJavaClassPaths()) {
            classPath = URLDecoder.decode(classPath, CharsetUtil.defaultCharset());
            this.scanFile(new File(classPath), null);
        }
    }

    private void scanFile(File file, String rootDir) {
        File[] files;
        if (file.isFile()) {
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(".class")) {
                String className = fileName.substring(rootDir.length(), fileName.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(className);
            } else if (fileName.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
        } else if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File subFile : files) {
                this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    private void scanJar(JarFile jar) {
        for (JarEntry entry : new EnumerationIter<JarEntry>(jar.entries())) {
            String name = StrUtil.removePrefix(entry.getName(), "/");
            if (!StrUtil.isEmpty(this.packagePath) && !name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            this.addIfAccept(this.loadClass(className));
        }
    }

    protected Class<?> loadClass(String className) {
        ClassLoader loader = this.classLoader;
        if (null == loader) {
            this.classLoader = loader = ClassLoaderUtil.getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, this.initialize, loader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
        }
        catch (Exception e) {
            this.classesOfLoadError.add(className);
        }
        catch (Throwable e) {
            if (!this.ignoreLoadError) {
                throw ExceptionUtil.wrapRuntime(e);
            }
            this.classesOfLoadError.add(className);
        }
        return clazz;
    }

    private void addIfAccept(String className) {
        int packageLen;
        if (StrUtil.isBlank(className)) {
            return;
        }
        int classLen = className.length();
        if (classLen == (packageLen = this.packageName.length())) {
            if (className.equals(this.packageName)) {
                this.addIfAccept(this.loadClass(className));
            }
        } else if (classLen > packageLen && (".".equals(this.packageNameWithDot) || className.startsWith(this.packageNameWithDot))) {
            this.addIfAccept(this.loadClass(className));
        }
    }

    private void addIfAccept(Class<?> clazz) {
        Predicate<Class<?>> classFilter;
        if (null != clazz && ((classFilter = this.classPredicate) == null || classFilter.test(clazz))) {
            this.classes.add(clazz);
        }
    }

    private String subPathBeforePackage(File file) {
        String filePath = file.getAbsolutePath();
        if (StrUtil.isNotEmpty(this.packageDirName)) {
            filePath = StrUtil.subBefore((CharSequence)filePath, this.packageDirName, true);
        }
        return StrUtil.addSuffixIfNot(filePath, File.separator);
    }
}

