/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern;

import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.builder.Builder;
import org.dromara.hutool.core.text.StrJoiner;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.cron.pattern.Part;

public class CronPatternBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    final String[] parts = new String[7];

    public static CronPatternBuilder of() {
        return new CronPatternBuilder();
    }

    public CronPatternBuilder setValues(Part part, int ... values) {
        for (int value : values) {
            part.checkValue(value);
        }
        return this.set(part, ArrayUtil.join((Object)values, (CharSequence)","));
    }

    public CronPatternBuilder setRange(Part part, int begin, int end) {
        Assert.notNull((Object)((Object)part));
        part.checkValue(begin);
        part.checkValue(end);
        return this.set(part, StrUtil.format((CharSequence)"{}-{}", (Object[])new Object[]{begin, end}));
    }

    public CronPatternBuilder set(Part part, String value) {
        this.parts[part.ordinal()] = value;
        return this;
    }

    public String build() {
        for (int i = Part.MINUTE.ordinal(); i < Part.YEAR.ordinal(); ++i) {
            if (!StrUtil.isBlank((CharSequence)this.parts[i])) continue;
            this.parts[i] = "*";
        }
        return StrJoiner.of((CharSequence)" ").setNullMode(StrJoiner.NullMode.IGNORE).append((Object[])this.parts).toString();
    }
}

