/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.dromara.hutool.core.date.CalendarUtil;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.cron.pattern.CronPattern;

public class CronPatternUtil {
    public static Date nextDateAfter(CronPattern pattern, Date start) {
        return DateUtil.date((Calendar)pattern.nextMatchAfter(CalendarUtil.calendar((Date)start)));
    }

    public static List<Date> matchedDates(String patternStr, Date start, int count) {
        return CronPatternUtil.matchedDates(patternStr, start, (Date)DateUtil.endOfYear((Date)start), count);
    }

    public static List<Date> matchedDates(String patternStr, Date start, Date end, int count) {
        return CronPatternUtil.matchedDates(patternStr, start.getTime(), end.getTime(), count);
    }

    public static List<Date> matchedDates(String patternStr, long start, long end, int count) {
        return CronPatternUtil.matchedDates(new CronPattern(patternStr), start, end, count);
    }

    public static List<Date> matchedDates(CronPattern pattern, long start, long end, int count) {
        Assert.isTrue((start < end ? 1 : 0) != 0, (String)"Start date is later than end !", (Object[])new Object[0]);
        ArrayList<Date> result = new ArrayList<Date>(count);
        Calendar calendar = pattern.nextMatchAfter(CalendarUtil.calendar((long)start));
        while (calendar.getTimeInMillis() < end) {
            result.add((Date)DateUtil.date((Calendar)calendar));
            if (result.size() >= count) break;
            calendar = pattern.nextMatchAfter(calendar);
        }
        return result;
    }
}

