/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dromara.hutool.core.map.TripleTable;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.cron.CronException;
import org.dromara.hutool.cron.Scheduler;
import org.dromara.hutool.cron.pattern.CronPattern;
import org.dromara.hutool.cron.task.CronTask;
import org.dromara.hutool.cron.task.Task;

public class TaskTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_CAPACITY = 10;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final TripleTable<String, CronPattern, Task> table;

    public TaskTable() {
        this(10);
    }

    public TaskTable(int initialCapacity) {
        this.table = new TripleTable(initialCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskTable add(String id, CronPattern pattern, Task task) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            if (this.table.containLeft((Object)id)) {
                throw new CronException("Id [{}] has been existed!", id);
            }
            this.table.put((Object)id, (Object)pattern, (Object)task);
        }
        finally {
            writeLock.unlock();
        }
        return this;
    }

    public List<String> getIds() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List list = this.table.getLefts();
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public List<CronPattern> getPatterns() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List list = this.table.getMiddles();
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public List<Task> getTasks() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List list = this.table.getRights();
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String id) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            int index = this.table.indexOfLeft((Object)id);
            if (index > -1) {
                this.table.remove(index);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePattern(String id, CronPattern pattern) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            int index = this.table.indexOfLeft((Object)id);
            if (index > -1) {
                this.table.setMiddle(index, (Object)pattern);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getTask(int index) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Task task = (Task)this.table.getRight(index);
            return task;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getTask(String id) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Task task = (Task)this.table.getRightByLeft((Object)id);
            return task;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronPattern getPattern(String id) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            CronPattern cronPattern = (CronPattern)this.table.getMiddleByLeft((Object)id);
            return cronPattern;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronPattern getPattern(int index) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            CronPattern cronPattern = (CronPattern)this.table.getMiddle(index);
            return cronPattern;
        }
        finally {
            readLock.unlock();
        }
    }

    public int size() {
        return this.table.size();
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTaskIfMatch(Scheduler scheduler, long millis) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            this.executeTaskIfMatchInternal(scheduler, millis);
        }
        finally {
            readLock.unlock();
        }
    }

    public String toString() {
        int size = this.size();
        StringBuilder builder = StrUtil.builder();
        for (int i = 0; i < size; ++i) {
            builder.append(StrUtil.format((CharSequence)"[{}] [{}] [{}]\n", (Object[])new Object[]{this.table.getLeft(i), this.table.getMiddle(i), this.table.getRight(i)}));
        }
        return builder.toString();
    }

    protected void executeTaskIfMatchInternal(Scheduler scheduler, long millis) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!((CronPattern)this.table.getMiddle(i)).match(scheduler.config.timezone, millis, scheduler.config.matchSecond)) continue;
            scheduler.taskExecutorManager.spawnExecutor(new CronTask((String)this.table.getLeft(i), (CronPattern)this.table.getMiddle(i), (Task)this.table.getRight(i)));
        }
    }
}

