/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern.builder;

import java.util.ArrayList;
import java.util.List;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.lang.builder.Builder;

public interface PartBuilder
extends Builder<String> {
    public static Always always() {
        return Always.INSTANCE;
    }

    public static class Every
    implements PartBuilder {
        private static final long serialVersionUID = 1L;
        private final PartBuilder partBuilder;
        private final int step;

        public Every(int step) {
            this(PartBuilder.always(), step);
        }

        public Every(PartBuilder partBuilder, int step) {
            this.partBuilder = partBuilder;
            this.step = step;
        }

        public String build() {
            String build = (String)this.partBuilder.build();
            if ("*".equals(build) && 1 == this.step) {
                return build;
            }
            return build + "/" + this.step;
        }
    }

    public static class And
    implements PartBuilder {
        private static final long serialVersionUID = 1L;
        private final List<PartBuilder> builders;

        public And(int ... values) {
            this.builders = new ArrayList<PartBuilder>(values.length);
            for (int value : values) {
                this.builders.add(new On(value));
            }
        }

        public And(PartBuilder ... builders) {
            this.builders = ListUtil.of((Object[])builders);
        }

        public And and(PartBuilder builder) {
            this.builders.add(builder);
            return this;
        }

        public String build() {
            return CollUtil.join(this.builders, (CharSequence)",", Builder::build);
        }
    }

    public static class Range
    implements PartBuilder {
        private static final long serialVersionUID = 1L;
        private final String start;
        private final String end;

        public Range(int start, int end) {
            this(String.valueOf(start), String.valueOf(end));
        }

        public Range(String start, String end) {
            this.start = start;
            this.end = end;
        }

        public String build() {
            return this.start + "-" + this.end;
        }
    }

    public static class On
    implements PartBuilder {
        private static final long serialVersionUID = 1L;
        private final String value;

        public On(int value) {
            this(String.valueOf(value));
        }

        public On(String value) {
            this.value = value;
        }

        public String build() {
            return this.value;
        }
    }

    public static class Always
    implements PartBuilder {
        private static final long serialVersionUID = 1L;
        public static final Always INSTANCE = new Always();

        public String build() {
            return "*";
        }
    }
}

