/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern.matcher;

import java.util.List;
import org.dromara.hutool.core.date.Month;
import org.dromara.hutool.cron.pattern.matcher.BoolArrayMatcher;

public class DayOfMonthMatcher
extends BoolArrayMatcher {
    public DayOfMonthMatcher(List<Integer> intValueList) {
        super(intValueList);
    }

    public boolean match(int value, int month, boolean isLeapYear) {
        return super.test(value) || this.matchLastDay(value, DayOfMonthMatcher.getLastDay(month, isLeapYear));
    }

    public int nextAfter(int value, int month, boolean isLeapYear) {
        int minValue = this.getMinValue(month, isLeapYear);
        if (value > minValue) {
            boolean[] bValues = this.bValues;
            while (value < bValues.length) {
                if (bValues[value]) {
                    if (31 == value) {
                        return DayOfMonthMatcher.getLastDay(month, isLeapYear);
                    }
                    return value;
                }
                ++value;
            }
        }
        return minValue;
    }

    public int getMinValue(int month, boolean isLeapYear) {
        int minValue = super.getMinValue();
        if (31 == minValue) {
            return DayOfMonthMatcher.getLastDay(month, isLeapYear);
        }
        return minValue;
    }

    private boolean matchLastDay(int value, int lastDay) {
        return value > 27 && this.test(31) && value == lastDay;
    }

    private static int getLastDay(int month, boolean isLeapYear) {
        return Month.getLastDay((int)(month - 1), (boolean)isLeapYear);
    }
}

