/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.task;

import java.lang.reflect.Method;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.cron.CronException;
import org.dromara.hutool.cron.task.Task;

public class InvokeTask
implements Task {
    private final Object obj;
    private final Method method;

    public InvokeTask(String classNameWithMethodName) {
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new HutoolException("Invalid classNameWithMethodName [{}]!", new Object[]{classNameWithMethodName});
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        if (StrUtil.isBlank((CharSequence)className)) {
            throw new IllegalArgumentException("Class name is blank !");
        }
        Class clazz = ClassLoaderUtil.loadClass((String)className);
        if (null == clazz) {
            throw new IllegalArgumentException("Load class with name of [" + className + "] fail !");
        }
        this.obj = ConstructorUtil.newInstanceIfPossible((Class)clazz);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        if (StrUtil.isBlank((CharSequence)methodName)) {
            throw new IllegalArgumentException("Method name is blank !");
        }
        this.method = MethodUtil.getPublicMethod((Class)clazz, (String)methodName, (Class[])new Class[0]);
        if (null == this.method) {
            throw new IllegalArgumentException("No method with name of [" + methodName + "] !");
        }
    }

    @Override
    public void execute() {
        try {
            MethodUtil.invoke((Object)this.obj, (Method)this.method, (Object[])new Object[0]);
        }
        catch (HutoolException e) {
            throw new CronException(e.getCause());
        }
    }
}

