/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern.parser;

import java.util.ArrayList;
import java.util.List;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.date.Month;
import org.dromara.hutool.core.date.Week;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.cron.CronException;
import org.dromara.hutool.cron.pattern.Part;
import org.dromara.hutool.cron.pattern.matcher.AlwaysTrueMatcher;
import org.dromara.hutool.cron.pattern.matcher.BoolArrayMatcher;
import org.dromara.hutool.cron.pattern.matcher.DayOfMonthMatcher;
import org.dromara.hutool.cron.pattern.matcher.PartMatcher;
import org.dromara.hutool.cron.pattern.matcher.YearValueMatcher;

public class PartParser {
    private final Part part;

    public static PartParser of(Part part) {
        return new PartParser(part);
    }

    public PartParser(Part part) {
        this.part = part;
    }

    public PartMatcher parse(String value) {
        if (PartParser.isMatchAllStr(value)) {
            return new AlwaysTrueMatcher();
        }
        List<Integer> values = this.parseArray(value);
        if (values.size() == 0) {
            throw new CronException("Invalid part value: [{}]", value);
        }
        switch (this.part) {
            case DAY_OF_MONTH: {
                return new DayOfMonthMatcher(values);
            }
            case YEAR: {
                return new YearValueMatcher(values);
            }
        }
        return new BoolArrayMatcher(values);
    }

    private List<Integer> parseArray(String value) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        List parts = SplitUtil.split((CharSequence)value, (CharSequence)",");
        for (String part : parts) {
            ListUtil.addAllIfNotContains(values, this.parseStep(part));
        }
        return values;
    }

    private List<Integer> parseStep(String value) {
        List<Integer> results;
        List parts = SplitUtil.split((CharSequence)value, (CharSequence)"/");
        int size = parts.size();
        if (size == 1) {
            results = this.parseRange(value, -1);
        } else if (size == 2) {
            int step = this.parseNumber((String)parts.get(1));
            if (step < 1) {
                throw new CronException("Non positive divisor for field: [{}]", value);
            }
            results = this.parseRange((String)parts.get(0), step);
        } else {
            throw new CronException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }

    private List<Integer> parseRange(String value, int step) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (value.length() <= 2) {
            int minValue = this.part.getMin();
            if (!PartParser.isMatchAllStr(value)) {
                minValue = Math.max(minValue, this.parseNumber(value));
            } else if (step < 1) {
                step = 1;
            }
            if (step > 0) {
                int maxValue = this.part.getMax();
                if (minValue > maxValue) {
                    throw new CronException("Invalid value {} > {}", minValue, maxValue);
                }
                for (int i = minValue; i <= maxValue; i += step) {
                    results.add(i);
                }
            } else {
                results.add(minValue);
            }
            return results;
        }
        List parts = SplitUtil.split((CharSequence)value, (CharSequence)"-");
        int size = parts.size();
        if (size == 1) {
            int v1 = this.parseNumber(value);
            if (step > 0) {
                NumberUtil.appendRange((int)v1, (int)this.part.getMax(), (int)step, results);
            } else {
                results.add(v1);
            }
        } else if (size == 2) {
            int v1 = this.parseNumber((String)parts.get(0));
            int v2 = this.parseNumber((String)parts.get(1));
            if (step < 1) {
                step = 1;
            }
            if (v1 < v2) {
                NumberUtil.appendRange((int)v1, (int)v2, (int)step, results);
            } else if (v1 > v2) {
                NumberUtil.appendRange((int)v1, (int)this.part.getMax(), (int)step, results);
                NumberUtil.appendRange((int)this.part.getMin(), (int)v2, (int)step, results);
            } else {
                NumberUtil.appendRange((int)v1, (int)this.part.getMax(), (int)step, results);
            }
        } else {
            throw new CronException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }

    private static boolean isMatchAllStr(String value) {
        return 1 == value.length() && ("*".equals(value) || "?".equals(value));
    }

    private int parseNumber(String value) throws CronException {
        int i;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException ignore) {
            i = this.parseAlias(value);
        }
        if (i < 0) {
            i += this.part.getMax();
        }
        if (Part.DAY_OF_WEEK.equals((Object)this.part) && Week.SUNDAY.getIso8601Value() == i) {
            i = Week.SUNDAY.ordinal();
        }
        return this.part.checkValue(i);
    }

    private int parseAlias(String name) throws CronException {
        if ("L".equalsIgnoreCase(name)) {
            return this.part.getMax();
        }
        switch (this.part) {
            case MONTH: {
                return Month.of((String)name).getValueBaseOne();
            }
            case DAY_OF_WEEK: {
                return Week.of((String)name).ordinal();
            }
        }
        throw new CronException("Invalid alias value: [{}]", name);
    }
}

