/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern.matcher;

import java.util.Collections;
import java.util.List;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.cron.pattern.matcher.PartMatcher;

public class BoolArrayMatcher
implements PartMatcher {
    private final int minValue;
    private final boolean[] bValues;

    public BoolArrayMatcher(List<Integer> intValueList) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(intValueList), (String)"Values must be not empty!", (Object[])new Object[0]);
        this.bValues = new boolean[Collections.max(intValueList) + 1];
        int min = Integer.MAX_VALUE;
        for (Integer value : intValueList) {
            min = Math.min(min, value);
            this.bValues[value.intValue()] = true;
        }
        this.minValue = min;
    }

    @Override
    public boolean test(Integer value) {
        if (null == value || value >= this.bValues.length) {
            return false;
        }
        return this.bValues[value];
    }

    @Override
    public int nextAfter(int value) {
        if (value > this.minValue) {
            while (value < this.bValues.length) {
                if (this.bValues[value]) {
                    return value;
                }
                ++value;
            }
        }
        return this.minValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public String toString() {
        return StrUtil.format((CharSequence)"Matcher:{}", (Object[])new Object[]{this.bValues});
    }
}

