/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.date.DateUnit;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.cron.pattern.CronPattern;

public class CronPatternUtil {
    public static Date nextDateAfter(CronPattern pattern, Date start, boolean isMatchSecond) {
        List<Date> matchedDates = CronPatternUtil.matchedDates(pattern, start.getTime(), DateUtil.endOfYear((Date)start).getTime(), 1, isMatchSecond);
        if (CollUtil.isNotEmpty(matchedDates)) {
            return matchedDates.get(0);
        }
        return null;
    }

    public static List<Date> matchedDates(String patternStr, Date start, int count, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(patternStr, start, (Date)DateUtil.endOfYear((Date)start), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, Date start, Date end, int count, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(patternStr, start.getTime(), end.getTime(), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, long start, long end, int count, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(new CronPattern(patternStr), start, end, count, isMatchSecond);
    }

    public static List<Date> matchedDates(CronPattern pattern, long start, long end, int count, boolean isMatchSecond) {
        Assert.isTrue((start < end ? 1 : 0) != 0, (String)"Start date is later than end !", (Object[])new Object[0]);
        ArrayList<Date> result = new ArrayList<Date>(count);
        long step = isMatchSecond ? DateUnit.SECOND.getMillis() : DateUnit.MINUTE.getMillis();
        for (long i = start; i < end; i += step) {
            if (!pattern.match(i, isMatchSecond)) continue;
            result.add((Date)DateUtil.date((long)i));
            if (result.size() >= count) break;
        }
        return result;
    }
}

