/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.asymmetric.KeyType;

public interface AsymmetricDecryptor {
    public byte[] decrypt(byte[] var1, KeyType var2);

    default public byte[] decrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes((InputStream)data), keyType);
    }

    default public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(SecureUtil.decode(data), keyType);
    }

    default public String decryptStr(String data, KeyType keyType, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(data, keyType), (Charset)charset);
    }

    default public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, CharsetUtil.UTF_8);
    }
}

