/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.codec.HexUtil;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.crypto.asymmetric.KeyType;

public interface AsymmetricEncryptor {
    public byte[] encrypt(byte[] var1, KeyType var2);

    default public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    default public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(ByteUtil.toBytes((CharSequence)data, (Charset)charset), keyType);
    }

    default public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(ByteUtil.toUtf8Bytes((CharSequence)data), keyType);
    }

    default public String encryptHex(String data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    default public String encryptHex(String data, Charset charset, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset, keyType));
    }

    default public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, charset, keyType));
    }

    default public byte[] encrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes((InputStream)data), keyType);
    }

    default public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }
}

